/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.AggregateEvaluationResult;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;

public class GetAggregateComplianceDetailsByConfigRulePublisher
implements SdkPublisher<GetAggregateComplianceDetailsByConfigRuleResponse> {
    private final ConfigAsyncClient client;
    private final GetAggregateComplianceDetailsByConfigRuleRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAggregateComplianceDetailsByConfigRulePublisher(ConfigAsyncClient client, GetAggregateComplianceDetailsByConfigRuleRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAggregateComplianceDetailsByConfigRulePublisher(ConfigAsyncClient client, GetAggregateComplianceDetailsByConfigRuleRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAggregateComplianceDetailsByConfigRuleResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAggregateComplianceDetailsByConfigRuleResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AggregateEvaluationResult> aggregateEvaluationResults() {
        return this.flatMapIterable(response -> response.aggregateEvaluationResults());
    }

    private class GetAggregateComplianceDetailsByConfigRuleResponseFetcher
    implements AsyncPageFetcher<GetAggregateComplianceDetailsByConfigRuleResponse> {
        private GetAggregateComplianceDetailsByConfigRuleResponseFetcher() {
        }

        public boolean hasNextPage(GetAggregateComplianceDetailsByConfigRuleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetAggregateComplianceDetailsByConfigRuleResponse> nextPage(GetAggregateComplianceDetailsByConfigRuleResponse previousPage) {
            if (previousPage == null) {
                return GetAggregateComplianceDetailsByConfigRulePublisher.this.client.getAggregateComplianceDetailsByConfigRule(GetAggregateComplianceDetailsByConfigRulePublisher.this.firstRequest);
            }
            return GetAggregateComplianceDetailsByConfigRulePublisher.this.client.getAggregateComplianceDetailsByConfigRule((GetAggregateComplianceDetailsByConfigRuleRequest)((Object)GetAggregateComplianceDetailsByConfigRulePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

