/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceSummary;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse;

public class GetConformancePackComplianceSummaryPublisher
implements SdkPublisher<GetConformancePackComplianceSummaryResponse> {
    private final ConfigAsyncClient client;
    private final GetConformancePackComplianceSummaryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetConformancePackComplianceSummaryPublisher(ConfigAsyncClient client, GetConformancePackComplianceSummaryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetConformancePackComplianceSummaryPublisher(ConfigAsyncClient client, GetConformancePackComplianceSummaryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetConformancePackComplianceSummaryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetConformancePackComplianceSummaryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConformancePackComplianceSummary> conformancePackComplianceSummaryList() {
        return this.flatMapIterable(response -> response.conformancePackComplianceSummaryList());
    }

    private class GetConformancePackComplianceSummaryResponseFetcher
    implements AsyncPageFetcher<GetConformancePackComplianceSummaryResponse> {
        private GetConformancePackComplianceSummaryResponseFetcher() {
        }

        public boolean hasNextPage(GetConformancePackComplianceSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetConformancePackComplianceSummaryResponse> nextPage(GetConformancePackComplianceSummaryResponse previousPage) {
            if (previousPage == null) {
                return GetConformancePackComplianceSummaryPublisher.this.client.getConformancePackComplianceSummary(GetConformancePackComplianceSummaryPublisher.this.firstRequest);
            }
            return GetConformancePackComplianceSummaryPublisher.this.client.getConformancePackComplianceSummary((GetConformancePackComplianceSummaryRequest)((Object)GetConformancePackComplianceSummaryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

