/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.Condition;
import software.amazon.awssdk.services.connect.model.ConditionsCopier;
import software.amazon.awssdk.services.connect.model.TargetListType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListCondition> {
    private static final SdkField<String> TARGET_LIST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetListType").getter(ListCondition.getter(ListCondition::targetListTypeAsString)).setter(ListCondition.setter(Builder::targetListType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetListType").build()}).build();
    private static final SdkField<List<Condition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Conditions").getter(ListCondition.getter(ListCondition::conditions)).setter(ListCondition.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_LIST_TYPE_FIELD, CONDITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetListType;
    private final List<Condition> conditions;

    private ListCondition(BuilderImpl builder) {
        this.targetListType = builder.targetListType;
        this.conditions = builder.conditions;
    }

    public final TargetListType targetListType() {
        return TargetListType.fromValue(this.targetListType);
    }

    public final String targetListTypeAsString() {
        return this.targetListType;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<Condition> conditions() {
        return this.conditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetListTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCondition)) {
            return false;
        }
        ListCondition other = (ListCondition)obj;
        return Objects.equals(this.targetListTypeAsString(), other.targetListTypeAsString()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions());
    }

    public final String toString() {
        return ToString.builder((String)"ListCondition").add("TargetListType", (Object)this.targetListTypeAsString()).add("Conditions", this.hasConditions() ? this.conditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetListType": {
                return Optional.ofNullable(clazz.cast(this.targetListTypeAsString()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetListType", TARGET_LIST_TYPE_FIELD);
        map.put("Conditions", CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCondition, T> g) {
        return obj -> g.apply((ListCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetListType;
        private List<Condition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCondition model) {
            this.targetListType(model.targetListType);
            this.conditions(model.conditions);
        }

        public final String getTargetListType() {
            return this.targetListType;
        }

        public final void setTargetListType(String targetListType) {
            this.targetListType = targetListType;
        }

        @Override
        public final Builder targetListType(String targetListType) {
            this.targetListType = targetListType;
            return this;
        }

        @Override
        public final Builder targetListType(TargetListType targetListType) {
            this.targetListType(targetListType == null ? null : targetListType.toString());
            return this;
        }

        public final List<Condition.Builder> getConditions() {
            List<Condition.Builder> result = ConditionsCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<Condition.BuilderImpl> conditions) {
            this.conditions = ConditionsCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<Condition> conditions) {
            this.conditions = ConditionsCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Condition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<Condition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (Condition)((Condition.Builder)Condition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ListCondition build() {
            return new ListCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListCondition> {
        public Builder targetListType(String var1);

        public Builder targetListType(TargetListType var1);

        public Builder conditions(Collection<Condition> var1);

        public Builder conditions(Condition ... var1);

        public Builder conditions(Consumer<Condition.Builder> ... var1);
    }
}

