/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.UserProficiency;
import software.amazon.awssdk.services.connect.model.UserProficiencyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUserProficienciesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListUserProficienciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUserProficienciesResponse.getter(ListUserProficienciesResponse::nextToken)).setter(ListUserProficienciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<UserProficiency>> USER_PROFICIENCY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserProficiencyList").getter(ListUserProficienciesResponse.getter(ListUserProficienciesResponse::userProficiencyList)).setter(ListUserProficienciesResponse.setter(Builder::userProficiencyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProficiencyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserProficiency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ListUserProficienciesResponse.getter(ListUserProficienciesResponse::lastModifiedTime)).setter(ListUserProficienciesResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(ListUserProficienciesResponse.getter(ListUserProficienciesResponse::lastModifiedRegion)).setter(ListUserProficienciesResponse.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, USER_PROFICIENCY_LIST_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUserProficienciesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<UserProficiency> userProficiencyList;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private ListUserProficienciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.userProficiencyList = builder.userProficiencyList;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasUserProficiencyList() {
        return this.userProficiencyList != null && !(this.userProficiencyList instanceof SdkAutoConstructList);
    }

    public final List<UserProficiency> userProficiencyList() {
        return this.userProficiencyList;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserProficiencyList() ? this.userProficiencyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserProficienciesResponse)) {
            return false;
        }
        ListUserProficienciesResponse other = (ListUserProficienciesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasUserProficiencyList() == other.hasUserProficiencyList() && Objects.equals(this.userProficiencyList(), other.userProficiencyList()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"ListUserProficienciesResponse").add("NextToken", (Object)this.nextToken()).add("UserProficiencyList", this.hasUserProficiencyList() ? this.userProficiencyList() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "UserProficiencyList": {
                return Optional.ofNullable(clazz.cast(this.userProficiencyList()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("UserProficiencyList", USER_PROFICIENCY_LIST_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUserProficienciesResponse, T> g) {
        return obj -> g.apply((ListUserProficienciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<UserProficiency> userProficiencyList = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserProficienciesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.userProficiencyList(model.userProficiencyList);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UserProficiency.Builder> getUserProficiencyList() {
            List<UserProficiency.Builder> result = UserProficiencyListCopier.copyToBuilder(this.userProficiencyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserProficiencyList(Collection<UserProficiency.BuilderImpl> userProficiencyList) {
            this.userProficiencyList = UserProficiencyListCopier.copyFromBuilder(userProficiencyList);
        }

        @Override
        public final Builder userProficiencyList(Collection<UserProficiency> userProficiencyList) {
            this.userProficiencyList = UserProficiencyListCopier.copy(userProficiencyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProficiencyList(UserProficiency ... userProficiencyList) {
            this.userProficiencyList(Arrays.asList(userProficiencyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProficiencyList(Consumer<UserProficiency.Builder> ... userProficiencyList) {
            this.userProficiencyList(Stream.of(userProficiencyList).map(c -> (UserProficiency)((UserProficiency.Builder)UserProficiency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public ListUserProficienciesResponse build() {
            return new ListUserProficienciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUserProficienciesResponse> {
        public Builder nextToken(String var1);

        public Builder userProficiencyList(Collection<UserProficiency> var1);

        public Builder userProficiencyList(UserProficiency ... var1);

        public Builder userProficiencyList(Consumer<UserProficiency.Builder> ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

