/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.SearchSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.SecurityProfileSearchSummary;

public class SearchSecurityProfilesPublisher
implements SdkPublisher<SearchSecurityProfilesResponse> {
    private final ConnectAsyncClient client;
    private final SearchSecurityProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchSecurityProfilesPublisher(ConnectAsyncClient client, SearchSecurityProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchSecurityProfilesPublisher(ConnectAsyncClient client, SearchSecurityProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchSecurityProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchSecurityProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityProfileSearchSummary> securityProfiles() {
        Function<SearchSecurityProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityProfiles() != null) {
                return response.securityProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchSecurityProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchSecurityProfilesResponseFetcher
    implements AsyncPageFetcher<SearchSecurityProfilesResponse> {
        private SearchSecurityProfilesResponseFetcher() {
        }

        public boolean hasNextPage(SearchSecurityProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchSecurityProfilesResponse> nextPage(SearchSecurityProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchSecurityProfilesPublisher.this.client.searchSecurityProfiles(SearchSecurityProfilesPublisher.this.firstRequest);
            }
            return SearchSecurityProfilesPublisher.this.client.searchSecurityProfiles((SearchSecurityProfilesRequest)((Object)SearchSecurityProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

