/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AdditionalEmailRecipients;
import software.amazon.awssdk.services.connect.model.AgentInfo;
import software.amazon.awssdk.services.connect.model.AnsweringMachineDetectionStatus;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.Campaign;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.ContactDetails;
import software.amazon.awssdk.services.connect.model.ContactEvaluation;
import software.amazon.awssdk.services.connect.model.ContactEvaluationsCopier;
import software.amazon.awssdk.services.connect.model.ContactInitiationMethod;
import software.amazon.awssdk.services.connect.model.ContactTagMapCopier;
import software.amazon.awssdk.services.connect.model.Customer;
import software.amazon.awssdk.services.connect.model.CustomerVoiceActivity;
import software.amazon.awssdk.services.connect.model.DisconnectDetails;
import software.amazon.awssdk.services.connect.model.EndpointInfo;
import software.amazon.awssdk.services.connect.model.QualityMetrics;
import software.amazon.awssdk.services.connect.model.QueueInfo;
import software.amazon.awssdk.services.connect.model.RecordingInfo;
import software.amazon.awssdk.services.connect.model.RecordingsCopier;
import software.amazon.awssdk.services.connect.model.RoutingCriteria;
import software.amazon.awssdk.services.connect.model.SegmentAttributeValue;
import software.amazon.awssdk.services.connect.model.SegmentAttributesCopier;
import software.amazon.awssdk.services.connect.model.WisdomInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Contact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Contact> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Contact.getter(Contact::arn)).setter(Contact.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Contact.getter(Contact::id)).setter(Contact.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitialContactId").getter(Contact.getter(Contact::initialContactId)).setter(Contact.setter(Builder::initialContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()}).build();
    private static final SdkField<String> PREVIOUS_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousContactId").getter(Contact.getter(Contact::previousContactId)).setter(Contact.setter(Builder::previousContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousContactId").build()}).build();
    private static final SdkField<String> CONTACT_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactAssociationId").getter(Contact.getter(Contact::contactAssociationId)).setter(Contact.setter(Builder::contactAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactAssociationId").build()}).build();
    private static final SdkField<String> INITIATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiationMethod").getter(Contact.getter(Contact::initiationMethodAsString)).setter(Contact.setter(Builder::initiationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethod").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Contact.getter(Contact::name)).setter(Contact.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Contact.getter(Contact::description)).setter(Contact.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(Contact.getter(Contact::channelAsString)).setter(Contact.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final SdkField<QueueInfo> QUEUE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueueInfo").getter(Contact.getter(Contact::queueInfo)).setter(Contact.setter(Builder::queueInfo)).constructor(QueueInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueInfo").build()}).build();
    private static final SdkField<AgentInfo> AGENT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AgentInfo").getter(Contact.getter(Contact::agentInfo)).setter(Contact.setter(Builder::agentInfo)).constructor(AgentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentInfo").build()}).build();
    private static final SdkField<Instant> INITIATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InitiationTimestamp").getter(Contact.getter(Contact::initiationTimestamp)).setter(Contact.setter(Builder::initiationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTimestamp").build()}).build();
    private static final SdkField<Instant> DISCONNECT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DisconnectTimestamp").getter(Contact.getter(Contact::disconnectTimestamp)).setter(Contact.setter(Builder::disconnectTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTimestamp").getter(Contact.getter(Contact::lastUpdateTimestamp)).setter(Contact.setter(Builder::lastUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_PAUSED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastPausedTimestamp").getter(Contact.getter(Contact::lastPausedTimestamp)).setter(Contact.setter(Builder::lastPausedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPausedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_RESUMED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastResumedTimestamp").getter(Contact.getter(Contact::lastResumedTimestamp)).setter(Contact.setter(Builder::lastResumedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastResumedTimestamp").build()}).build();
    private static final SdkField<Integer> TOTAL_PAUSE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalPauseCount").getter(Contact.getter(Contact::totalPauseCount)).setter(Contact.setter(Builder::totalPauseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalPauseCount").build()}).build();
    private static final SdkField<Integer> TOTAL_PAUSE_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalPauseDurationInSeconds").getter(Contact.getter(Contact::totalPauseDurationInSeconds)).setter(Contact.setter(Builder::totalPauseDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalPauseDurationInSeconds").build()}).build();
    private static final SdkField<Instant> SCHEDULED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledTimestamp").getter(Contact.getter(Contact::scheduledTimestamp)).setter(Contact.setter(Builder::scheduledTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTimestamp").build()}).build();
    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedContactId").getter(Contact.getter(Contact::relatedContactId)).setter(Contact.setter(Builder::relatedContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()}).build();
    private static final SdkField<WisdomInfo> WISDOM_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WisdomInfo").getter(Contact.getter(Contact::wisdomInfo)).setter(Contact.setter(Builder::wisdomInfo)).constructor(WisdomInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WisdomInfo").build()}).build();
    private static final SdkField<String> CUSTOMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerId").getter(Contact.getter(Contact::customerId)).setter(Contact.setter(Builder::customerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerId").build()}).build();
    private static final SdkField<EndpointInfo> CUSTOMER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerEndpoint").getter(Contact.getter(Contact::customerEndpoint)).setter(Contact.setter(Builder::customerEndpoint)).constructor(EndpointInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerEndpoint").build()}).build();
    private static final SdkField<EndpointInfo> SYSTEM_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SystemEndpoint").getter(Contact.getter(Contact::systemEndpoint)).setter(Contact.setter(Builder::systemEndpoint)).constructor(EndpointInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemEndpoint").build()}).build();
    private static final SdkField<Integer> QUEUE_TIME_ADJUSTMENT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("QueueTimeAdjustmentSeconds").getter(Contact.getter(Contact::queueTimeAdjustmentSeconds)).setter(Contact.setter(Builder::queueTimeAdjustmentSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueTimeAdjustmentSeconds").build()}).build();
    private static final SdkField<Long> QUEUE_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("QueuePriority").getter(Contact.getter(Contact::queuePriority)).setter(Contact.setter(Builder::queuePriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueuePriority").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Contact.getter(Contact::tags)).setter(Contact.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CONNECTED_TO_SYSTEM_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ConnectedToSystemTimestamp").getter(Contact.getter(Contact::connectedToSystemTimestamp)).setter(Contact.setter(Builder::connectedToSystemTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedToSystemTimestamp").build()}).build();
    private static final SdkField<RoutingCriteria> ROUTING_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingCriteria").getter(Contact.getter(Contact::routingCriteria)).setter(Contact.setter(Builder::routingCriteria)).constructor(RoutingCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingCriteria").build()}).build();
    private static final SdkField<Customer> CUSTOMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customer").getter(Contact.getter(Contact::customer)).setter(Contact.setter(Builder::customer)).constructor(Customer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()}).build();
    private static final SdkField<Campaign> CAMPAIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Campaign").getter(Contact.getter(Contact::campaign)).setter(Contact.setter(Builder::campaign)).constructor(Campaign::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Campaign").build()}).build();
    private static final SdkField<String> ANSWERING_MACHINE_DETECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnsweringMachineDetectionStatus").getter(Contact.getter(Contact::answeringMachineDetectionStatusAsString)).setter(Contact.setter(Builder::answeringMachineDetectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnsweringMachineDetectionStatus").build()}).build();
    private static final SdkField<CustomerVoiceActivity> CUSTOMER_VOICE_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerVoiceActivity").getter(Contact.getter(Contact::customerVoiceActivity)).setter(Contact.setter(Builder::customerVoiceActivity)).constructor(CustomerVoiceActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerVoiceActivity").build()}).build();
    private static final SdkField<QualityMetrics> QUALITY_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QualityMetrics").getter(Contact.getter(Contact::qualityMetrics)).setter(Contact.setter(Builder::qualityMetrics)).constructor(QualityMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityMetrics").build()}).build();
    private static final SdkField<DisconnectDetails> DISCONNECT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisconnectDetails").getter(Contact.getter(Contact::disconnectDetails)).setter(Contact.setter(Builder::disconnectDetails)).constructor(DisconnectDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectDetails").build()}).build();
    private static final SdkField<AdditionalEmailRecipients> ADDITIONAL_EMAIL_RECIPIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalEmailRecipients").getter(Contact.getter(Contact::additionalEmailRecipients)).setter(Contact.setter(Builder::additionalEmailRecipients)).constructor(AdditionalEmailRecipients::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEmailRecipients").build()}).build();
    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SegmentAttributes").getter(Contact.getter(Contact::segmentAttributes)).setter(Contact.setter(Builder::segmentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<RecordingInfo>> RECORDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Recordings").getter(Contact.getter(Contact::recordings)).setter(Contact.setter(Builder::recordings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recordings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DISCONNECT_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisconnectReason").getter(Contact.getter(Contact::disconnectReason)).setter(Contact.setter(Builder::disconnectReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectReason").build()}).build();
    private static final SdkField<Map<String, ContactEvaluation>> CONTACT_EVALUATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ContactEvaluations").getter(Contact.getter(Contact::contactEvaluations)).setter(Contact.setter(Builder::contactEvaluations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactEvaluations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactEvaluation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ContactDetails> CONTACT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContactDetails").getter(Contact.getter(Contact::contactDetails)).setter(Contact.setter(Builder::contactDetails)).constructor(ContactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactDetails").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(Contact.getter(Contact::attributes)).setter(Contact.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, INITIAL_CONTACT_ID_FIELD, PREVIOUS_CONTACT_ID_FIELD, CONTACT_ASSOCIATION_ID_FIELD, INITIATION_METHOD_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CHANNEL_FIELD, QUEUE_INFO_FIELD, AGENT_INFO_FIELD, INITIATION_TIMESTAMP_FIELD, DISCONNECT_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD, LAST_PAUSED_TIMESTAMP_FIELD, LAST_RESUMED_TIMESTAMP_FIELD, TOTAL_PAUSE_COUNT_FIELD, TOTAL_PAUSE_DURATION_IN_SECONDS_FIELD, SCHEDULED_TIMESTAMP_FIELD, RELATED_CONTACT_ID_FIELD, WISDOM_INFO_FIELD, CUSTOMER_ID_FIELD, CUSTOMER_ENDPOINT_FIELD, SYSTEM_ENDPOINT_FIELD, QUEUE_TIME_ADJUSTMENT_SECONDS_FIELD, QUEUE_PRIORITY_FIELD, TAGS_FIELD, CONNECTED_TO_SYSTEM_TIMESTAMP_FIELD, ROUTING_CRITERIA_FIELD, CUSTOMER_FIELD, CAMPAIGN_FIELD, ANSWERING_MACHINE_DETECTION_STATUS_FIELD, CUSTOMER_VOICE_ACTIVITY_FIELD, QUALITY_METRICS_FIELD, DISCONNECT_DETAILS_FIELD, ADDITIONAL_EMAIL_RECIPIENTS_FIELD, SEGMENT_ATTRIBUTES_FIELD, RECORDINGS_FIELD, DISCONNECT_REASON_FIELD, CONTACT_EVALUATIONS_FIELD, CONTACT_DETAILS_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Contact.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String initialContactId;
    private final String previousContactId;
    private final String contactAssociationId;
    private final String initiationMethod;
    private final String name;
    private final String description;
    private final String channel;
    private final QueueInfo queueInfo;
    private final AgentInfo agentInfo;
    private final Instant initiationTimestamp;
    private final Instant disconnectTimestamp;
    private final Instant lastUpdateTimestamp;
    private final Instant lastPausedTimestamp;
    private final Instant lastResumedTimestamp;
    private final Integer totalPauseCount;
    private final Integer totalPauseDurationInSeconds;
    private final Instant scheduledTimestamp;
    private final String relatedContactId;
    private final WisdomInfo wisdomInfo;
    private final String customerId;
    private final EndpointInfo customerEndpoint;
    private final EndpointInfo systemEndpoint;
    private final Integer queueTimeAdjustmentSeconds;
    private final Long queuePriority;
    private final Map<String, String> tags;
    private final Instant connectedToSystemTimestamp;
    private final RoutingCriteria routingCriteria;
    private final Customer customer;
    private final Campaign campaign;
    private final String answeringMachineDetectionStatus;
    private final CustomerVoiceActivity customerVoiceActivity;
    private final QualityMetrics qualityMetrics;
    private final DisconnectDetails disconnectDetails;
    private final AdditionalEmailRecipients additionalEmailRecipients;
    private final Map<String, SegmentAttributeValue> segmentAttributes;
    private final List<RecordingInfo> recordings;
    private final String disconnectReason;
    private final Map<String, ContactEvaluation> contactEvaluations;
    private final ContactDetails contactDetails;
    private final Map<String, String> attributes;

    private Contact(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.initialContactId = builder.initialContactId;
        this.previousContactId = builder.previousContactId;
        this.contactAssociationId = builder.contactAssociationId;
        this.initiationMethod = builder.initiationMethod;
        this.name = builder.name;
        this.description = builder.description;
        this.channel = builder.channel;
        this.queueInfo = builder.queueInfo;
        this.agentInfo = builder.agentInfo;
        this.initiationTimestamp = builder.initiationTimestamp;
        this.disconnectTimestamp = builder.disconnectTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.lastPausedTimestamp = builder.lastPausedTimestamp;
        this.lastResumedTimestamp = builder.lastResumedTimestamp;
        this.totalPauseCount = builder.totalPauseCount;
        this.totalPauseDurationInSeconds = builder.totalPauseDurationInSeconds;
        this.scheduledTimestamp = builder.scheduledTimestamp;
        this.relatedContactId = builder.relatedContactId;
        this.wisdomInfo = builder.wisdomInfo;
        this.customerId = builder.customerId;
        this.customerEndpoint = builder.customerEndpoint;
        this.systemEndpoint = builder.systemEndpoint;
        this.queueTimeAdjustmentSeconds = builder.queueTimeAdjustmentSeconds;
        this.queuePriority = builder.queuePriority;
        this.tags = builder.tags;
        this.connectedToSystemTimestamp = builder.connectedToSystemTimestamp;
        this.routingCriteria = builder.routingCriteria;
        this.customer = builder.customer;
        this.campaign = builder.campaign;
        this.answeringMachineDetectionStatus = builder.answeringMachineDetectionStatus;
        this.customerVoiceActivity = builder.customerVoiceActivity;
        this.qualityMetrics = builder.qualityMetrics;
        this.disconnectDetails = builder.disconnectDetails;
        this.additionalEmailRecipients = builder.additionalEmailRecipients;
        this.segmentAttributes = builder.segmentAttributes;
        this.recordings = builder.recordings;
        this.disconnectReason = builder.disconnectReason;
        this.contactEvaluations = builder.contactEvaluations;
        this.contactDetails = builder.contactDetails;
        this.attributes = builder.attributes;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String initialContactId() {
        return this.initialContactId;
    }

    public final String previousContactId() {
        return this.previousContactId;
    }

    public final String contactAssociationId() {
        return this.contactAssociationId;
    }

    public final ContactInitiationMethod initiationMethod() {
        return ContactInitiationMethod.fromValue(this.initiationMethod);
    }

    public final String initiationMethodAsString() {
        return this.initiationMethod;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final QueueInfo queueInfo() {
        return this.queueInfo;
    }

    public final AgentInfo agentInfo() {
        return this.agentInfo;
    }

    public final Instant initiationTimestamp() {
        return this.initiationTimestamp;
    }

    public final Instant disconnectTimestamp() {
        return this.disconnectTimestamp;
    }

    public final Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public final Instant lastPausedTimestamp() {
        return this.lastPausedTimestamp;
    }

    public final Instant lastResumedTimestamp() {
        return this.lastResumedTimestamp;
    }

    public final Integer totalPauseCount() {
        return this.totalPauseCount;
    }

    public final Integer totalPauseDurationInSeconds() {
        return this.totalPauseDurationInSeconds;
    }

    public final Instant scheduledTimestamp() {
        return this.scheduledTimestamp;
    }

    public final String relatedContactId() {
        return this.relatedContactId;
    }

    public final WisdomInfo wisdomInfo() {
        return this.wisdomInfo;
    }

    public final String customerId() {
        return this.customerId;
    }

    public final EndpointInfo customerEndpoint() {
        return this.customerEndpoint;
    }

    public final EndpointInfo systemEndpoint() {
        return this.systemEndpoint;
    }

    public final Integer queueTimeAdjustmentSeconds() {
        return this.queueTimeAdjustmentSeconds;
    }

    public final Long queuePriority() {
        return this.queuePriority;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant connectedToSystemTimestamp() {
        return this.connectedToSystemTimestamp;
    }

    public final RoutingCriteria routingCriteria() {
        return this.routingCriteria;
    }

    public final Customer customer() {
        return this.customer;
    }

    public final Campaign campaign() {
        return this.campaign;
    }

    public final AnsweringMachineDetectionStatus answeringMachineDetectionStatus() {
        return AnsweringMachineDetectionStatus.fromValue(this.answeringMachineDetectionStatus);
    }

    public final String answeringMachineDetectionStatusAsString() {
        return this.answeringMachineDetectionStatus;
    }

    public final CustomerVoiceActivity customerVoiceActivity() {
        return this.customerVoiceActivity;
    }

    public final QualityMetrics qualityMetrics() {
        return this.qualityMetrics;
    }

    public final DisconnectDetails disconnectDetails() {
        return this.disconnectDetails;
    }

    public final AdditionalEmailRecipients additionalEmailRecipients() {
        return this.additionalEmailRecipients;
    }

    public final boolean hasSegmentAttributes() {
        return this.segmentAttributes != null && !(this.segmentAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return this.segmentAttributes;
    }

    public final boolean hasRecordings() {
        return this.recordings != null && !(this.recordings instanceof SdkAutoConstructList);
    }

    public final List<RecordingInfo> recordings() {
        return this.recordings;
    }

    public final String disconnectReason() {
        return this.disconnectReason;
    }

    public final boolean hasContactEvaluations() {
        return this.contactEvaluations != null && !(this.contactEvaluations instanceof SdkAutoConstructMap);
    }

    public final Map<String, ContactEvaluation> contactEvaluations() {
        return this.contactEvaluations;
    }

    public final ContactDetails contactDetails() {
        return this.contactDetails;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastPausedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastResumedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalPauseCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalPauseDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.wisdomInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueTimeAdjustmentSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuePriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectedToSystemTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.customer());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaign());
        hashCode = 31 * hashCode + Objects.hashCode(this.answeringMachineDetectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerVoiceActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalEmailRecipients());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentAttributes() ? this.segmentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordings() ? this.recordings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactEvaluations() ? this.contactEvaluations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Contact)) {
            return false;
        }
        Contact other = (Contact)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.initialContactId(), other.initialContactId()) && Objects.equals(this.previousContactId(), other.previousContactId()) && Objects.equals(this.contactAssociationId(), other.contactAssociationId()) && Objects.equals(this.initiationMethodAsString(), other.initiationMethodAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.queueInfo(), other.queueInfo()) && Objects.equals(this.agentInfo(), other.agentInfo()) && Objects.equals(this.initiationTimestamp(), other.initiationTimestamp()) && Objects.equals(this.disconnectTimestamp(), other.disconnectTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(this.lastPausedTimestamp(), other.lastPausedTimestamp()) && Objects.equals(this.lastResumedTimestamp(), other.lastResumedTimestamp()) && Objects.equals(this.totalPauseCount(), other.totalPauseCount()) && Objects.equals(this.totalPauseDurationInSeconds(), other.totalPauseDurationInSeconds()) && Objects.equals(this.scheduledTimestamp(), other.scheduledTimestamp()) && Objects.equals(this.relatedContactId(), other.relatedContactId()) && Objects.equals(this.wisdomInfo(), other.wisdomInfo()) && Objects.equals(this.customerId(), other.customerId()) && Objects.equals(this.customerEndpoint(), other.customerEndpoint()) && Objects.equals(this.systemEndpoint(), other.systemEndpoint()) && Objects.equals(this.queueTimeAdjustmentSeconds(), other.queueTimeAdjustmentSeconds()) && Objects.equals(this.queuePriority(), other.queuePriority()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.connectedToSystemTimestamp(), other.connectedToSystemTimestamp()) && Objects.equals(this.routingCriteria(), other.routingCriteria()) && Objects.equals(this.customer(), other.customer()) && Objects.equals(this.campaign(), other.campaign()) && Objects.equals(this.answeringMachineDetectionStatusAsString(), other.answeringMachineDetectionStatusAsString()) && Objects.equals(this.customerVoiceActivity(), other.customerVoiceActivity()) && Objects.equals(this.qualityMetrics(), other.qualityMetrics()) && Objects.equals(this.disconnectDetails(), other.disconnectDetails()) && Objects.equals(this.additionalEmailRecipients(), other.additionalEmailRecipients()) && this.hasSegmentAttributes() == other.hasSegmentAttributes() && Objects.equals(this.segmentAttributes(), other.segmentAttributes()) && this.hasRecordings() == other.hasRecordings() && Objects.equals(this.recordings(), other.recordings()) && Objects.equals(this.disconnectReason(), other.disconnectReason()) && this.hasContactEvaluations() == other.hasContactEvaluations() && Objects.equals(this.contactEvaluations(), other.contactEvaluations()) && Objects.equals(this.contactDetails(), other.contactDetails()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"Contact").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("InitialContactId", (Object)this.initialContactId()).add("PreviousContactId", (Object)this.previousContactId()).add("ContactAssociationId", (Object)this.contactAssociationId()).add("InitiationMethod", (Object)this.initiationMethodAsString()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Channel", (Object)this.channelAsString()).add("QueueInfo", (Object)this.queueInfo()).add("AgentInfo", (Object)this.agentInfo()).add("InitiationTimestamp", (Object)this.initiationTimestamp()).add("DisconnectTimestamp", (Object)this.disconnectTimestamp()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).add("LastPausedTimestamp", (Object)this.lastPausedTimestamp()).add("LastResumedTimestamp", (Object)this.lastResumedTimestamp()).add("TotalPauseCount", (Object)this.totalPauseCount()).add("TotalPauseDurationInSeconds", (Object)this.totalPauseDurationInSeconds()).add("ScheduledTimestamp", (Object)this.scheduledTimestamp()).add("RelatedContactId", (Object)this.relatedContactId()).add("WisdomInfo", (Object)this.wisdomInfo()).add("CustomerId", (Object)this.customerId()).add("CustomerEndpoint", (Object)this.customerEndpoint()).add("SystemEndpoint", (Object)this.systemEndpoint()).add("QueueTimeAdjustmentSeconds", (Object)this.queueTimeAdjustmentSeconds()).add("QueuePriority", (Object)this.queuePriority()).add("Tags", this.hasTags() ? this.tags() : null).add("ConnectedToSystemTimestamp", (Object)this.connectedToSystemTimestamp()).add("RoutingCriteria", (Object)this.routingCriteria()).add("Customer", (Object)this.customer()).add("Campaign", (Object)this.campaign()).add("AnsweringMachineDetectionStatus", (Object)this.answeringMachineDetectionStatusAsString()).add("CustomerVoiceActivity", (Object)this.customerVoiceActivity()).add("QualityMetrics", (Object)this.qualityMetrics()).add("DisconnectDetails", (Object)this.disconnectDetails()).add("AdditionalEmailRecipients", (Object)this.additionalEmailRecipients()).add("SegmentAttributes", this.hasSegmentAttributes() ? this.segmentAttributes() : null).add("Recordings", this.hasRecordings() ? this.recordings() : null).add("DisconnectReason", (Object)this.disconnectReason()).add("ContactEvaluations", this.hasContactEvaluations() ? this.contactEvaluations() : null).add("ContactDetails", (Object)this.contactDetails()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InitialContactId": {
                return Optional.ofNullable(clazz.cast(this.initialContactId()));
            }
            case "PreviousContactId": {
                return Optional.ofNullable(clazz.cast(this.previousContactId()));
            }
            case "ContactAssociationId": {
                return Optional.ofNullable(clazz.cast(this.contactAssociationId()));
            }
            case "InitiationMethod": {
                return Optional.ofNullable(clazz.cast(this.initiationMethodAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "QueueInfo": {
                return Optional.ofNullable(clazz.cast(this.queueInfo()));
            }
            case "AgentInfo": {
                return Optional.ofNullable(clazz.cast(this.agentInfo()));
            }
            case "InitiationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.initiationTimestamp()));
            }
            case "DisconnectTimestamp": {
                return Optional.ofNullable(clazz.cast(this.disconnectTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "LastPausedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastPausedTimestamp()));
            }
            case "LastResumedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastResumedTimestamp()));
            }
            case "TotalPauseCount": {
                return Optional.ofNullable(clazz.cast(this.totalPauseCount()));
            }
            case "TotalPauseDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.totalPauseDurationInSeconds()));
            }
            case "ScheduledTimestamp": {
                return Optional.ofNullable(clazz.cast(this.scheduledTimestamp()));
            }
            case "RelatedContactId": {
                return Optional.ofNullable(clazz.cast(this.relatedContactId()));
            }
            case "WisdomInfo": {
                return Optional.ofNullable(clazz.cast(this.wisdomInfo()));
            }
            case "CustomerId": {
                return Optional.ofNullable(clazz.cast(this.customerId()));
            }
            case "CustomerEndpoint": {
                return Optional.ofNullable(clazz.cast(this.customerEndpoint()));
            }
            case "SystemEndpoint": {
                return Optional.ofNullable(clazz.cast(this.systemEndpoint()));
            }
            case "QueueTimeAdjustmentSeconds": {
                return Optional.ofNullable(clazz.cast(this.queueTimeAdjustmentSeconds()));
            }
            case "QueuePriority": {
                return Optional.ofNullable(clazz.cast(this.queuePriority()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConnectedToSystemTimestamp": {
                return Optional.ofNullable(clazz.cast(this.connectedToSystemTimestamp()));
            }
            case "RoutingCriteria": {
                return Optional.ofNullable(clazz.cast(this.routingCriteria()));
            }
            case "Customer": {
                return Optional.ofNullable(clazz.cast(this.customer()));
            }
            case "Campaign": {
                return Optional.ofNullable(clazz.cast(this.campaign()));
            }
            case "AnsweringMachineDetectionStatus": {
                return Optional.ofNullable(clazz.cast(this.answeringMachineDetectionStatusAsString()));
            }
            case "CustomerVoiceActivity": {
                return Optional.ofNullable(clazz.cast(this.customerVoiceActivity()));
            }
            case "QualityMetrics": {
                return Optional.ofNullable(clazz.cast(this.qualityMetrics()));
            }
            case "DisconnectDetails": {
                return Optional.ofNullable(clazz.cast(this.disconnectDetails()));
            }
            case "AdditionalEmailRecipients": {
                return Optional.ofNullable(clazz.cast(this.additionalEmailRecipients()));
            }
            case "SegmentAttributes": {
                return Optional.ofNullable(clazz.cast(this.segmentAttributes()));
            }
            case "Recordings": {
                return Optional.ofNullable(clazz.cast(this.recordings()));
            }
            case "DisconnectReason": {
                return Optional.ofNullable(clazz.cast(this.disconnectReason()));
            }
            case "ContactEvaluations": {
                return Optional.ofNullable(clazz.cast(this.contactEvaluations()));
            }
            case "ContactDetails": {
                return Optional.ofNullable(clazz.cast(this.contactDetails()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("InitialContactId", INITIAL_CONTACT_ID_FIELD);
        map.put("PreviousContactId", PREVIOUS_CONTACT_ID_FIELD);
        map.put("ContactAssociationId", CONTACT_ASSOCIATION_ID_FIELD);
        map.put("InitiationMethod", INITIATION_METHOD_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        map.put("QueueInfo", QUEUE_INFO_FIELD);
        map.put("AgentInfo", AGENT_INFO_FIELD);
        map.put("InitiationTimestamp", INITIATION_TIMESTAMP_FIELD);
        map.put("DisconnectTimestamp", DISCONNECT_TIMESTAMP_FIELD);
        map.put("LastUpdateTimestamp", LAST_UPDATE_TIMESTAMP_FIELD);
        map.put("LastPausedTimestamp", LAST_PAUSED_TIMESTAMP_FIELD);
        map.put("LastResumedTimestamp", LAST_RESUMED_TIMESTAMP_FIELD);
        map.put("TotalPauseCount", TOTAL_PAUSE_COUNT_FIELD);
        map.put("TotalPauseDurationInSeconds", TOTAL_PAUSE_DURATION_IN_SECONDS_FIELD);
        map.put("ScheduledTimestamp", SCHEDULED_TIMESTAMP_FIELD);
        map.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
        map.put("WisdomInfo", WISDOM_INFO_FIELD);
        map.put("CustomerId", CUSTOMER_ID_FIELD);
        map.put("CustomerEndpoint", CUSTOMER_ENDPOINT_FIELD);
        map.put("SystemEndpoint", SYSTEM_ENDPOINT_FIELD);
        map.put("QueueTimeAdjustmentSeconds", QUEUE_TIME_ADJUSTMENT_SECONDS_FIELD);
        map.put("QueuePriority", QUEUE_PRIORITY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ConnectedToSystemTimestamp", CONNECTED_TO_SYSTEM_TIMESTAMP_FIELD);
        map.put("RoutingCriteria", ROUTING_CRITERIA_FIELD);
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Campaign", CAMPAIGN_FIELD);
        map.put("AnsweringMachineDetectionStatus", ANSWERING_MACHINE_DETECTION_STATUS_FIELD);
        map.put("CustomerVoiceActivity", CUSTOMER_VOICE_ACTIVITY_FIELD);
        map.put("QualityMetrics", QUALITY_METRICS_FIELD);
        map.put("DisconnectDetails", DISCONNECT_DETAILS_FIELD);
        map.put("AdditionalEmailRecipients", ADDITIONAL_EMAIL_RECIPIENTS_FIELD);
        map.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        map.put("Recordings", RECORDINGS_FIELD);
        map.put("DisconnectReason", DISCONNECT_REASON_FIELD);
        map.put("ContactEvaluations", CONTACT_EVALUATIONS_FIELD);
        map.put("ContactDetails", CONTACT_DETAILS_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Contact, T> g) {
        return obj -> g.apply((Contact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String initialContactId;
        private String previousContactId;
        private String contactAssociationId;
        private String initiationMethod;
        private String name;
        private String description;
        private String channel;
        private QueueInfo queueInfo;
        private AgentInfo agentInfo;
        private Instant initiationTimestamp;
        private Instant disconnectTimestamp;
        private Instant lastUpdateTimestamp;
        private Instant lastPausedTimestamp;
        private Instant lastResumedTimestamp;
        private Integer totalPauseCount;
        private Integer totalPauseDurationInSeconds;
        private Instant scheduledTimestamp;
        private String relatedContactId;
        private WisdomInfo wisdomInfo;
        private String customerId;
        private EndpointInfo customerEndpoint;
        private EndpointInfo systemEndpoint;
        private Integer queueTimeAdjustmentSeconds;
        private Long queuePriority;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant connectedToSystemTimestamp;
        private RoutingCriteria routingCriteria;
        private Customer customer;
        private Campaign campaign;
        private String answeringMachineDetectionStatus;
        private CustomerVoiceActivity customerVoiceActivity;
        private QualityMetrics qualityMetrics;
        private DisconnectDetails disconnectDetails;
        private AdditionalEmailRecipients additionalEmailRecipients;
        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();
        private List<RecordingInfo> recordings = DefaultSdkAutoConstructList.getInstance();
        private String disconnectReason;
        private Map<String, ContactEvaluation> contactEvaluations = DefaultSdkAutoConstructMap.getInstance();
        private ContactDetails contactDetails;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Contact model) {
            this.arn(model.arn);
            this.id(model.id);
            this.initialContactId(model.initialContactId);
            this.previousContactId(model.previousContactId);
            this.contactAssociationId(model.contactAssociationId);
            this.initiationMethod(model.initiationMethod);
            this.name(model.name);
            this.description(model.description);
            this.channel(model.channel);
            this.queueInfo(model.queueInfo);
            this.agentInfo(model.agentInfo);
            this.initiationTimestamp(model.initiationTimestamp);
            this.disconnectTimestamp(model.disconnectTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.lastPausedTimestamp(model.lastPausedTimestamp);
            this.lastResumedTimestamp(model.lastResumedTimestamp);
            this.totalPauseCount(model.totalPauseCount);
            this.totalPauseDurationInSeconds(model.totalPauseDurationInSeconds);
            this.scheduledTimestamp(model.scheduledTimestamp);
            this.relatedContactId(model.relatedContactId);
            this.wisdomInfo(model.wisdomInfo);
            this.customerId(model.customerId);
            this.customerEndpoint(model.customerEndpoint);
            this.systemEndpoint(model.systemEndpoint);
            this.queueTimeAdjustmentSeconds(model.queueTimeAdjustmentSeconds);
            this.queuePriority(model.queuePriority);
            this.tags(model.tags);
            this.connectedToSystemTimestamp(model.connectedToSystemTimestamp);
            this.routingCriteria(model.routingCriteria);
            this.customer(model.customer);
            this.campaign(model.campaign);
            this.answeringMachineDetectionStatus(model.answeringMachineDetectionStatus);
            this.customerVoiceActivity(model.customerVoiceActivity);
            this.qualityMetrics(model.qualityMetrics);
            this.disconnectDetails(model.disconnectDetails);
            this.additionalEmailRecipients(model.additionalEmailRecipients);
            this.segmentAttributes(model.segmentAttributes);
            this.recordings(model.recordings);
            this.disconnectReason(model.disconnectReason);
            this.contactEvaluations(model.contactEvaluations);
            this.contactDetails(model.contactDetails);
            this.attributes(model.attributes);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInitialContactId() {
            return this.initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getPreviousContactId() {
            return this.previousContactId;
        }

        public final void setPreviousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
        }

        @Override
        public final Builder previousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
            return this;
        }

        public final String getContactAssociationId() {
            return this.contactAssociationId;
        }

        public final void setContactAssociationId(String contactAssociationId) {
            this.contactAssociationId = contactAssociationId;
        }

        @Override
        public final Builder contactAssociationId(String contactAssociationId) {
            this.contactAssociationId = contactAssociationId;
            return this;
        }

        public final String getInitiationMethod() {
            return this.initiationMethod;
        }

        public final void setInitiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
        }

        @Override
        public final Builder initiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
            return this;
        }

        @Override
        public final Builder initiationMethod(ContactInitiationMethod initiationMethod) {
            this.initiationMethod(initiationMethod == null ? null : initiationMethod.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final QueueInfo.Builder getQueueInfo() {
            return this.queueInfo != null ? this.queueInfo.toBuilder() : null;
        }

        public final void setQueueInfo(QueueInfo.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        @Override
        public final Builder queueInfo(QueueInfo queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final AgentInfo.Builder getAgentInfo() {
            return this.agentInfo != null ? this.agentInfo.toBuilder() : null;
        }

        public final void setAgentInfo(AgentInfo.BuilderImpl agentInfo) {
            this.agentInfo = agentInfo != null ? agentInfo.build() : null;
        }

        @Override
        public final Builder agentInfo(AgentInfo agentInfo) {
            this.agentInfo = agentInfo;
            return this;
        }

        public final Instant getInitiationTimestamp() {
            return this.initiationTimestamp;
        }

        public final void setInitiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
        }

        @Override
        public final Builder initiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
            return this;
        }

        public final Instant getDisconnectTimestamp() {
            return this.disconnectTimestamp;
        }

        public final void setDisconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
        }

        @Override
        public final Builder disconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final Instant getLastPausedTimestamp() {
            return this.lastPausedTimestamp;
        }

        public final void setLastPausedTimestamp(Instant lastPausedTimestamp) {
            this.lastPausedTimestamp = lastPausedTimestamp;
        }

        @Override
        public final Builder lastPausedTimestamp(Instant lastPausedTimestamp) {
            this.lastPausedTimestamp = lastPausedTimestamp;
            return this;
        }

        public final Instant getLastResumedTimestamp() {
            return this.lastResumedTimestamp;
        }

        public final void setLastResumedTimestamp(Instant lastResumedTimestamp) {
            this.lastResumedTimestamp = lastResumedTimestamp;
        }

        @Override
        public final Builder lastResumedTimestamp(Instant lastResumedTimestamp) {
            this.lastResumedTimestamp = lastResumedTimestamp;
            return this;
        }

        public final Integer getTotalPauseCount() {
            return this.totalPauseCount;
        }

        public final void setTotalPauseCount(Integer totalPauseCount) {
            this.totalPauseCount = totalPauseCount;
        }

        @Override
        public final Builder totalPauseCount(Integer totalPauseCount) {
            this.totalPauseCount = totalPauseCount;
            return this;
        }

        public final Integer getTotalPauseDurationInSeconds() {
            return this.totalPauseDurationInSeconds;
        }

        public final void setTotalPauseDurationInSeconds(Integer totalPauseDurationInSeconds) {
            this.totalPauseDurationInSeconds = totalPauseDurationInSeconds;
        }

        @Override
        public final Builder totalPauseDurationInSeconds(Integer totalPauseDurationInSeconds) {
            this.totalPauseDurationInSeconds = totalPauseDurationInSeconds;
            return this;
        }

        public final Instant getScheduledTimestamp() {
            return this.scheduledTimestamp;
        }

        public final void setScheduledTimestamp(Instant scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
        }

        @Override
        public final Builder scheduledTimestamp(Instant scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
            return this;
        }

        public final String getRelatedContactId() {
            return this.relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final WisdomInfo.Builder getWisdomInfo() {
            return this.wisdomInfo != null ? this.wisdomInfo.toBuilder() : null;
        }

        public final void setWisdomInfo(WisdomInfo.BuilderImpl wisdomInfo) {
            this.wisdomInfo = wisdomInfo != null ? wisdomInfo.build() : null;
        }

        @Override
        public final Builder wisdomInfo(WisdomInfo wisdomInfo) {
            this.wisdomInfo = wisdomInfo;
            return this;
        }

        public final String getCustomerId() {
            return this.customerId;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final EndpointInfo.Builder getCustomerEndpoint() {
            return this.customerEndpoint != null ? this.customerEndpoint.toBuilder() : null;
        }

        public final void setCustomerEndpoint(EndpointInfo.BuilderImpl customerEndpoint) {
            this.customerEndpoint = customerEndpoint != null ? customerEndpoint.build() : null;
        }

        @Override
        public final Builder customerEndpoint(EndpointInfo customerEndpoint) {
            this.customerEndpoint = customerEndpoint;
            return this;
        }

        public final EndpointInfo.Builder getSystemEndpoint() {
            return this.systemEndpoint != null ? this.systemEndpoint.toBuilder() : null;
        }

        public final void setSystemEndpoint(EndpointInfo.BuilderImpl systemEndpoint) {
            this.systemEndpoint = systemEndpoint != null ? systemEndpoint.build() : null;
        }

        @Override
        public final Builder systemEndpoint(EndpointInfo systemEndpoint) {
            this.systemEndpoint = systemEndpoint;
            return this;
        }

        public final Integer getQueueTimeAdjustmentSeconds() {
            return this.queueTimeAdjustmentSeconds;
        }

        public final void setQueueTimeAdjustmentSeconds(Integer queueTimeAdjustmentSeconds) {
            this.queueTimeAdjustmentSeconds = queueTimeAdjustmentSeconds;
        }

        @Override
        public final Builder queueTimeAdjustmentSeconds(Integer queueTimeAdjustmentSeconds) {
            this.queueTimeAdjustmentSeconds = queueTimeAdjustmentSeconds;
            return this;
        }

        public final Long getQueuePriority() {
            return this.queuePriority;
        }

        public final void setQueuePriority(Long queuePriority) {
            this.queuePriority = queuePriority;
        }

        @Override
        public final Builder queuePriority(Long queuePriority) {
            this.queuePriority = queuePriority;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ContactTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ContactTagMapCopier.copy(tags);
            return this;
        }

        public final Instant getConnectedToSystemTimestamp() {
            return this.connectedToSystemTimestamp;
        }

        public final void setConnectedToSystemTimestamp(Instant connectedToSystemTimestamp) {
            this.connectedToSystemTimestamp = connectedToSystemTimestamp;
        }

        @Override
        public final Builder connectedToSystemTimestamp(Instant connectedToSystemTimestamp) {
            this.connectedToSystemTimestamp = connectedToSystemTimestamp;
            return this;
        }

        public final RoutingCriteria.Builder getRoutingCriteria() {
            return this.routingCriteria != null ? this.routingCriteria.toBuilder() : null;
        }

        public final void setRoutingCriteria(RoutingCriteria.BuilderImpl routingCriteria) {
            this.routingCriteria = routingCriteria != null ? routingCriteria.build() : null;
        }

        @Override
        public final Builder routingCriteria(RoutingCriteria routingCriteria) {
            this.routingCriteria = routingCriteria;
            return this;
        }

        public final Customer.Builder getCustomer() {
            return this.customer != null ? this.customer.toBuilder() : null;
        }

        public final void setCustomer(Customer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public final Campaign.Builder getCampaign() {
            return this.campaign != null ? this.campaign.toBuilder() : null;
        }

        public final void setCampaign(Campaign.BuilderImpl campaign) {
            this.campaign = campaign != null ? campaign.build() : null;
        }

        @Override
        public final Builder campaign(Campaign campaign) {
            this.campaign = campaign;
            return this;
        }

        public final String getAnsweringMachineDetectionStatus() {
            return this.answeringMachineDetectionStatus;
        }

        public final void setAnsweringMachineDetectionStatus(String answeringMachineDetectionStatus) {
            this.answeringMachineDetectionStatus = answeringMachineDetectionStatus;
        }

        @Override
        public final Builder answeringMachineDetectionStatus(String answeringMachineDetectionStatus) {
            this.answeringMachineDetectionStatus = answeringMachineDetectionStatus;
            return this;
        }

        @Override
        public final Builder answeringMachineDetectionStatus(AnsweringMachineDetectionStatus answeringMachineDetectionStatus) {
            this.answeringMachineDetectionStatus(answeringMachineDetectionStatus == null ? null : answeringMachineDetectionStatus.toString());
            return this;
        }

        public final CustomerVoiceActivity.Builder getCustomerVoiceActivity() {
            return this.customerVoiceActivity != null ? this.customerVoiceActivity.toBuilder() : null;
        }

        public final void setCustomerVoiceActivity(CustomerVoiceActivity.BuilderImpl customerVoiceActivity) {
            this.customerVoiceActivity = customerVoiceActivity != null ? customerVoiceActivity.build() : null;
        }

        @Override
        public final Builder customerVoiceActivity(CustomerVoiceActivity customerVoiceActivity) {
            this.customerVoiceActivity = customerVoiceActivity;
            return this;
        }

        public final QualityMetrics.Builder getQualityMetrics() {
            return this.qualityMetrics != null ? this.qualityMetrics.toBuilder() : null;
        }

        public final void setQualityMetrics(QualityMetrics.BuilderImpl qualityMetrics) {
            this.qualityMetrics = qualityMetrics != null ? qualityMetrics.build() : null;
        }

        @Override
        public final Builder qualityMetrics(QualityMetrics qualityMetrics) {
            this.qualityMetrics = qualityMetrics;
            return this;
        }

        public final DisconnectDetails.Builder getDisconnectDetails() {
            return this.disconnectDetails != null ? this.disconnectDetails.toBuilder() : null;
        }

        public final void setDisconnectDetails(DisconnectDetails.BuilderImpl disconnectDetails) {
            this.disconnectDetails = disconnectDetails != null ? disconnectDetails.build() : null;
        }

        @Override
        public final Builder disconnectDetails(DisconnectDetails disconnectDetails) {
            this.disconnectDetails = disconnectDetails;
            return this;
        }

        public final AdditionalEmailRecipients.Builder getAdditionalEmailRecipients() {
            return this.additionalEmailRecipients != null ? this.additionalEmailRecipients.toBuilder() : null;
        }

        public final void setAdditionalEmailRecipients(AdditionalEmailRecipients.BuilderImpl additionalEmailRecipients) {
            this.additionalEmailRecipients = additionalEmailRecipients != null ? additionalEmailRecipients.build() : null;
        }

        @Override
        public final Builder additionalEmailRecipients(AdditionalEmailRecipients additionalEmailRecipients) {
            this.additionalEmailRecipients = additionalEmailRecipients;
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        public final List<RecordingInfo.Builder> getRecordings() {
            List<RecordingInfo.Builder> result = RecordingsCopier.copyToBuilder(this.recordings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecordings(Collection<RecordingInfo.BuilderImpl> recordings) {
            this.recordings = RecordingsCopier.copyFromBuilder(recordings);
        }

        @Override
        public final Builder recordings(Collection<RecordingInfo> recordings) {
            this.recordings = RecordingsCopier.copy(recordings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordings(RecordingInfo ... recordings) {
            this.recordings(Arrays.asList(recordings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordings(Consumer<RecordingInfo.Builder> ... recordings) {
            this.recordings(Stream.of(recordings).map(c -> (RecordingInfo)((RecordingInfo.Builder)RecordingInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDisconnectReason() {
            return this.disconnectReason;
        }

        public final void setDisconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
        }

        @Override
        public final Builder disconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
            return this;
        }

        public final Map<String, ContactEvaluation.Builder> getContactEvaluations() {
            Map<String, ContactEvaluation.Builder> result = ContactEvaluationsCopier.copyToBuilder(this.contactEvaluations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setContactEvaluations(Map<String, ContactEvaluation.BuilderImpl> contactEvaluations) {
            this.contactEvaluations = ContactEvaluationsCopier.copyFromBuilder(contactEvaluations);
        }

        @Override
        public final Builder contactEvaluations(Map<String, ContactEvaluation> contactEvaluations) {
            this.contactEvaluations = ContactEvaluationsCopier.copy(contactEvaluations);
            return this;
        }

        public final ContactDetails.Builder getContactDetails() {
            return this.contactDetails != null ? this.contactDetails.toBuilder() : null;
        }

        public final void setContactDetails(ContactDetails.BuilderImpl contactDetails) {
            this.contactDetails = contactDetails != null ? contactDetails.build() : null;
        }

        @Override
        public final Builder contactDetails(ContactDetails contactDetails) {
            this.contactDetails = contactDetails;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public Contact build() {
            return new Contact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Contact> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder initialContactId(String var1);

        public Builder previousContactId(String var1);

        public Builder contactAssociationId(String var1);

        public Builder initiationMethod(String var1);

        public Builder initiationMethod(ContactInitiationMethod var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder channel(String var1);

        public Builder channel(Channel var1);

        public Builder queueInfo(QueueInfo var1);

        default public Builder queueInfo(Consumer<QueueInfo.Builder> queueInfo) {
            return this.queueInfo((QueueInfo)((QueueInfo.Builder)QueueInfo.builder().applyMutation(queueInfo)).build());
        }

        public Builder agentInfo(AgentInfo var1);

        default public Builder agentInfo(Consumer<AgentInfo.Builder> agentInfo) {
            return this.agentInfo((AgentInfo)((AgentInfo.Builder)AgentInfo.builder().applyMutation(agentInfo)).build());
        }

        public Builder initiationTimestamp(Instant var1);

        public Builder disconnectTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder lastPausedTimestamp(Instant var1);

        public Builder lastResumedTimestamp(Instant var1);

        public Builder totalPauseCount(Integer var1);

        public Builder totalPauseDurationInSeconds(Integer var1);

        public Builder scheduledTimestamp(Instant var1);

        public Builder relatedContactId(String var1);

        public Builder wisdomInfo(WisdomInfo var1);

        default public Builder wisdomInfo(Consumer<WisdomInfo.Builder> wisdomInfo) {
            return this.wisdomInfo((WisdomInfo)((WisdomInfo.Builder)WisdomInfo.builder().applyMutation(wisdomInfo)).build());
        }

        public Builder customerId(String var1);

        public Builder customerEndpoint(EndpointInfo var1);

        default public Builder customerEndpoint(Consumer<EndpointInfo.Builder> customerEndpoint) {
            return this.customerEndpoint((EndpointInfo)((EndpointInfo.Builder)EndpointInfo.builder().applyMutation(customerEndpoint)).build());
        }

        public Builder systemEndpoint(EndpointInfo var1);

        default public Builder systemEndpoint(Consumer<EndpointInfo.Builder> systemEndpoint) {
            return this.systemEndpoint((EndpointInfo)((EndpointInfo.Builder)EndpointInfo.builder().applyMutation(systemEndpoint)).build());
        }

        public Builder queueTimeAdjustmentSeconds(Integer var1);

        public Builder queuePriority(Long var1);

        public Builder tags(Map<String, String> var1);

        public Builder connectedToSystemTimestamp(Instant var1);

        public Builder routingCriteria(RoutingCriteria var1);

        default public Builder routingCriteria(Consumer<RoutingCriteria.Builder> routingCriteria) {
            return this.routingCriteria((RoutingCriteria)((RoutingCriteria.Builder)RoutingCriteria.builder().applyMutation(routingCriteria)).build());
        }

        public Builder customer(Customer var1);

        default public Builder customer(Consumer<Customer.Builder> customer) {
            return this.customer((Customer)((Customer.Builder)Customer.builder().applyMutation(customer)).build());
        }

        public Builder campaign(Campaign var1);

        default public Builder campaign(Consumer<Campaign.Builder> campaign) {
            return this.campaign((Campaign)((Campaign.Builder)Campaign.builder().applyMutation(campaign)).build());
        }

        public Builder answeringMachineDetectionStatus(String var1);

        public Builder answeringMachineDetectionStatus(AnsweringMachineDetectionStatus var1);

        public Builder customerVoiceActivity(CustomerVoiceActivity var1);

        default public Builder customerVoiceActivity(Consumer<CustomerVoiceActivity.Builder> customerVoiceActivity) {
            return this.customerVoiceActivity((CustomerVoiceActivity)((CustomerVoiceActivity.Builder)CustomerVoiceActivity.builder().applyMutation(customerVoiceActivity)).build());
        }

        public Builder qualityMetrics(QualityMetrics var1);

        default public Builder qualityMetrics(Consumer<QualityMetrics.Builder> qualityMetrics) {
            return this.qualityMetrics((QualityMetrics)((QualityMetrics.Builder)QualityMetrics.builder().applyMutation(qualityMetrics)).build());
        }

        public Builder disconnectDetails(DisconnectDetails var1);

        default public Builder disconnectDetails(Consumer<DisconnectDetails.Builder> disconnectDetails) {
            return this.disconnectDetails((DisconnectDetails)((DisconnectDetails.Builder)DisconnectDetails.builder().applyMutation(disconnectDetails)).build());
        }

        public Builder additionalEmailRecipients(AdditionalEmailRecipients var1);

        default public Builder additionalEmailRecipients(Consumer<AdditionalEmailRecipients.Builder> additionalEmailRecipients) {
            return this.additionalEmailRecipients((AdditionalEmailRecipients)((AdditionalEmailRecipients.Builder)AdditionalEmailRecipients.builder().applyMutation(additionalEmailRecipients)).build());
        }

        public Builder segmentAttributes(Map<String, SegmentAttributeValue> var1);

        public Builder recordings(Collection<RecordingInfo> var1);

        public Builder recordings(RecordingInfo ... var1);

        public Builder recordings(Consumer<RecordingInfo.Builder> ... var1);

        public Builder disconnectReason(String var1);

        public Builder contactEvaluations(Map<String, ContactEvaluation> var1);

        public Builder contactDetails(ContactDetails var1);

        default public Builder contactDetails(Consumer<ContactDetails.Builder> contactDetails) {
            return this.contactDetails((ContactDetails)((ContactDetails.Builder)ContactDetails.builder().applyMutation(contactDetails)).build());
        }

        public Builder attributes(Map<String, String> var1);
    }
}

