/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactConfiguration;
import software.amazon.awssdk.services.connect.model.DeviceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePushNotificationRegistrationRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreatePushNotificationRegistrationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreatePushNotificationRegistrationRequest.getter(CreatePushNotificationRegistrationRequest::instanceId)).setter(CreatePushNotificationRegistrationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreatePushNotificationRegistrationRequest.getter(CreatePushNotificationRegistrationRequest::clientToken)).setter(CreatePushNotificationRegistrationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> PINPOINT_APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PinpointAppArn").getter(CreatePushNotificationRegistrationRequest.getter(CreatePushNotificationRegistrationRequest::pinpointAppArn)).setter(CreatePushNotificationRegistrationRequest.setter(Builder::pinpointAppArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinpointAppArn").build()}).build();
    private static final SdkField<String> DEVICE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceToken").getter(CreatePushNotificationRegistrationRequest.getter(CreatePushNotificationRegistrationRequest::deviceToken)).setter(CreatePushNotificationRegistrationRequest.setter(Builder::deviceToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceToken").build()}).build();
    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceType").getter(CreatePushNotificationRegistrationRequest.getter(CreatePushNotificationRegistrationRequest::deviceTypeAsString)).setter(CreatePushNotificationRegistrationRequest.setter(Builder::deviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()}).build();
    private static final SdkField<ContactConfiguration> CONTACT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContactConfiguration").getter(CreatePushNotificationRegistrationRequest.getter(CreatePushNotificationRegistrationRequest::contactConfiguration)).setter(CreatePushNotificationRegistrationRequest.setter(Builder::contactConfiguration)).constructor(ContactConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CLIENT_TOKEN_FIELD, PINPOINT_APP_ARN_FIELD, DEVICE_TOKEN_FIELD, DEVICE_TYPE_FIELD, CONTACT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePushNotificationRegistrationRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String clientToken;
    private final String pinpointAppArn;
    private final String deviceToken;
    private final String deviceType;
    private final ContactConfiguration contactConfiguration;

    private CreatePushNotificationRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.clientToken = builder.clientToken;
        this.pinpointAppArn = builder.pinpointAppArn;
        this.deviceToken = builder.deviceToken;
        this.deviceType = builder.deviceType;
        this.contactConfiguration = builder.contactConfiguration;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String pinpointAppArn() {
        return this.pinpointAppArn;
    }

    public final String deviceToken() {
        return this.deviceToken;
    }

    public final DeviceType deviceType() {
        return DeviceType.fromValue(this.deviceType);
    }

    public final String deviceTypeAsString() {
        return this.deviceType;
    }

    public final ContactConfiguration contactConfiguration() {
        return this.contactConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinpointAppArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePushNotificationRegistrationRequest)) {
            return false;
        }
        CreatePushNotificationRegistrationRequest other = (CreatePushNotificationRegistrationRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.pinpointAppArn(), other.pinpointAppArn()) && Objects.equals(this.deviceToken(), other.deviceToken()) && Objects.equals(this.deviceTypeAsString(), other.deviceTypeAsString()) && Objects.equals(this.contactConfiguration(), other.contactConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePushNotificationRegistrationRequest").add("InstanceId", (Object)this.instanceId()).add("ClientToken", (Object)this.clientToken()).add("PinpointAppArn", (Object)this.pinpointAppArn()).add("DeviceToken", (Object)this.deviceToken()).add("DeviceType", (Object)this.deviceTypeAsString()).add("ContactConfiguration", (Object)this.contactConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "PinpointAppArn": {
                return Optional.ofNullable(clazz.cast(this.pinpointAppArn()));
            }
            case "DeviceToken": {
                return Optional.ofNullable(clazz.cast(this.deviceToken()));
            }
            case "DeviceType": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeAsString()));
            }
            case "ContactConfiguration": {
                return Optional.ofNullable(clazz.cast(this.contactConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("PinpointAppArn", PINPOINT_APP_ARN_FIELD);
        map.put("DeviceToken", DEVICE_TOKEN_FIELD);
        map.put("DeviceType", DEVICE_TYPE_FIELD);
        map.put("ContactConfiguration", CONTACT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePushNotificationRegistrationRequest, T> g) {
        return obj -> g.apply((CreatePushNotificationRegistrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String clientToken;
        private String pinpointAppArn;
        private String deviceToken;
        private String deviceType;
        private ContactConfiguration contactConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePushNotificationRegistrationRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.clientToken(model.clientToken);
            this.pinpointAppArn(model.pinpointAppArn);
            this.deviceToken(model.deviceToken);
            this.deviceType(model.deviceType);
            this.contactConfiguration(model.contactConfiguration);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getPinpointAppArn() {
            return this.pinpointAppArn;
        }

        public final void setPinpointAppArn(String pinpointAppArn) {
            this.pinpointAppArn = pinpointAppArn;
        }

        @Override
        public final Builder pinpointAppArn(String pinpointAppArn) {
            this.pinpointAppArn = pinpointAppArn;
            return this;
        }

        public final String getDeviceToken() {
            return this.deviceToken;
        }

        public final void setDeviceToken(String deviceToken) {
            this.deviceToken = deviceToken;
        }

        @Override
        public final Builder deviceToken(String deviceToken) {
            this.deviceToken = deviceToken;
            return this;
        }

        public final String getDeviceType() {
            return this.deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        public final Builder deviceType(DeviceType deviceType) {
            this.deviceType(deviceType == null ? null : deviceType.toString());
            return this;
        }

        public final ContactConfiguration.Builder getContactConfiguration() {
            return this.contactConfiguration != null ? this.contactConfiguration.toBuilder() : null;
        }

        public final void setContactConfiguration(ContactConfiguration.BuilderImpl contactConfiguration) {
            this.contactConfiguration = contactConfiguration != null ? contactConfiguration.build() : null;
        }

        @Override
        public final Builder contactConfiguration(ContactConfiguration contactConfiguration) {
            this.contactConfiguration = contactConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePushNotificationRegistrationRequest build() {
            return new CreatePushNotificationRegistrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePushNotificationRegistrationRequest> {
        public Builder instanceId(String var1);

        public Builder clientToken(String var1);

        public Builder pinpointAppArn(String var1);

        public Builder deviceToken(String var1);

        public Builder deviceType(String var1);

        public Builder deviceType(DeviceType var1);

        public Builder contactConfiguration(ContactConfiguration var1);

        default public Builder contactConfiguration(Consumer<ContactConfiguration.Builder> contactConfiguration) {
            return this.contactConfiguration((ContactConfiguration)((ContactConfiguration.Builder)ContactConfiguration.builder().applyMutation(contactConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

