/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.DirectoryType;
import software.amazon.awssdk.services.connect.model.InstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(InstanceSummary.getter(InstanceSummary::id)).setter(InstanceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(InstanceSummary.getter(InstanceSummary::arn)).setter(InstanceSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> IDENTITY_MANAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityManagementType").getter(InstanceSummary.getter(InstanceSummary::identityManagementTypeAsString)).setter(InstanceSummary.setter(Builder::identityManagementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityManagementType").build()}).build();
    private static final SdkField<String> INSTANCE_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceAlias").getter(InstanceSummary.getter(InstanceSummary::instanceAlias)).setter(InstanceSummary.setter(Builder::instanceAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAlias").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(InstanceSummary.getter(InstanceSummary::createdTime)).setter(InstanceSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(InstanceSummary.getter(InstanceSummary::serviceRole)).setter(InstanceSummary.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<String> INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceStatus").getter(InstanceSummary.getter(InstanceSummary::instanceStatusAsString)).setter(InstanceSummary.setter(Builder::instanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()}).build();
    private static final SdkField<Boolean> INBOUND_CALLS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InboundCallsEnabled").getter(InstanceSummary.getter(InstanceSummary::inboundCallsEnabled)).setter(InstanceSummary.setter(Builder::inboundCallsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundCallsEnabled").build()}).build();
    private static final SdkField<Boolean> OUTBOUND_CALLS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OutboundCallsEnabled").getter(InstanceSummary.getter(InstanceSummary::outboundCallsEnabled)).setter(InstanceSummary.setter(Builder::outboundCallsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallsEnabled").build()}).build();
    private static final SdkField<String> INSTANCE_ACCESS_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceAccessUrl").getter(InstanceSummary.getter(InstanceSummary::instanceAccessUrl)).setter(InstanceSummary.setter(Builder::instanceAccessUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAccessUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, IDENTITY_MANAGEMENT_TYPE_FIELD, INSTANCE_ALIAS_FIELD, CREATED_TIME_FIELD, SERVICE_ROLE_FIELD, INSTANCE_STATUS_FIELD, INBOUND_CALLS_ENABLED_FIELD, OUTBOUND_CALLS_ENABLED_FIELD, INSTANCE_ACCESS_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String identityManagementType;
    private final String instanceAlias;
    private final Instant createdTime;
    private final String serviceRole;
    private final String instanceStatus;
    private final Boolean inboundCallsEnabled;
    private final Boolean outboundCallsEnabled;
    private final String instanceAccessUrl;

    private InstanceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.identityManagementType = builder.identityManagementType;
        this.instanceAlias = builder.instanceAlias;
        this.createdTime = builder.createdTime;
        this.serviceRole = builder.serviceRole;
        this.instanceStatus = builder.instanceStatus;
        this.inboundCallsEnabled = builder.inboundCallsEnabled;
        this.outboundCallsEnabled = builder.outboundCallsEnabled;
        this.instanceAccessUrl = builder.instanceAccessUrl;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final DirectoryType identityManagementType() {
        return DirectoryType.fromValue(this.identityManagementType);
    }

    public final String identityManagementTypeAsString() {
        return this.identityManagementType;
    }

    public final String instanceAlias() {
        return this.instanceAlias;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final InstanceStatus instanceStatus() {
        return InstanceStatus.fromValue(this.instanceStatus);
    }

    public final String instanceStatusAsString() {
        return this.instanceStatus;
    }

    public final Boolean inboundCallsEnabled() {
        return this.inboundCallsEnabled;
    }

    public final Boolean outboundCallsEnabled() {
        return this.outboundCallsEnabled;
    }

    public final String instanceAccessUrl() {
        return this.instanceAccessUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityManagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundCallsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundCallsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceAccessUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.identityManagementTypeAsString(), other.identityManagementTypeAsString()) && Objects.equals(this.instanceAlias(), other.instanceAlias()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.instanceStatusAsString(), other.instanceStatusAsString()) && Objects.equals(this.inboundCallsEnabled(), other.inboundCallsEnabled()) && Objects.equals(this.outboundCallsEnabled(), other.outboundCallsEnabled()) && Objects.equals(this.instanceAccessUrl(), other.instanceAccessUrl());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("IdentityManagementType", (Object)this.identityManagementTypeAsString()).add("InstanceAlias", (Object)(this.instanceAlias() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedTime", (Object)this.createdTime()).add("ServiceRole", (Object)this.serviceRole()).add("InstanceStatus", (Object)this.instanceStatusAsString()).add("InboundCallsEnabled", (Object)this.inboundCallsEnabled()).add("OutboundCallsEnabled", (Object)this.outboundCallsEnabled()).add("InstanceAccessUrl", (Object)this.instanceAccessUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "IdentityManagementType": {
                return Optional.ofNullable(clazz.cast(this.identityManagementTypeAsString()));
            }
            case "InstanceAlias": {
                return Optional.ofNullable(clazz.cast(this.instanceAlias()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "InstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.instanceStatusAsString()));
            }
            case "InboundCallsEnabled": {
                return Optional.ofNullable(clazz.cast(this.inboundCallsEnabled()));
            }
            case "OutboundCallsEnabled": {
                return Optional.ofNullable(clazz.cast(this.outboundCallsEnabled()));
            }
            case "InstanceAccessUrl": {
                return Optional.ofNullable(clazz.cast(this.instanceAccessUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("IdentityManagementType", IDENTITY_MANAGEMENT_TYPE_FIELD);
        map.put("InstanceAlias", INSTANCE_ALIAS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("ServiceRole", SERVICE_ROLE_FIELD);
        map.put("InstanceStatus", INSTANCE_STATUS_FIELD);
        map.put("InboundCallsEnabled", INBOUND_CALLS_ENABLED_FIELD);
        map.put("OutboundCallsEnabled", OUTBOUND_CALLS_ENABLED_FIELD);
        map.put("InstanceAccessUrl", INSTANCE_ACCESS_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceSummary, T> g) {
        return obj -> g.apply((InstanceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String identityManagementType;
        private String instanceAlias;
        private Instant createdTime;
        private String serviceRole;
        private String instanceStatus;
        private Boolean inboundCallsEnabled;
        private Boolean outboundCallsEnabled;
        private String instanceAccessUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.identityManagementType(model.identityManagementType);
            this.instanceAlias(model.instanceAlias);
            this.createdTime(model.createdTime);
            this.serviceRole(model.serviceRole);
            this.instanceStatus(model.instanceStatus);
            this.inboundCallsEnabled(model.inboundCallsEnabled);
            this.outboundCallsEnabled(model.outboundCallsEnabled);
            this.instanceAccessUrl(model.instanceAccessUrl);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getIdentityManagementType() {
            return this.identityManagementType;
        }

        public final void setIdentityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
        }

        @Override
        public final Builder identityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
            return this;
        }

        @Override
        public final Builder identityManagementType(DirectoryType identityManagementType) {
            this.identityManagementType(identityManagementType == null ? null : identityManagementType.toString());
            return this;
        }

        public final String getInstanceAlias() {
            return this.instanceAlias;
        }

        public final void setInstanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
        }

        @Override
        public final Builder instanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getInstanceStatus() {
            return this.instanceStatus;
        }

        public final void setInstanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
        }

        @Override
        public final Builder instanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        @Override
        public final Builder instanceStatus(InstanceStatus instanceStatus) {
            this.instanceStatus(instanceStatus == null ? null : instanceStatus.toString());
            return this;
        }

        public final Boolean getInboundCallsEnabled() {
            return this.inboundCallsEnabled;
        }

        public final void setInboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
        }

        @Override
        public final Builder inboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
            return this;
        }

        public final Boolean getOutboundCallsEnabled() {
            return this.outboundCallsEnabled;
        }

        public final void setOutboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
        }

        @Override
        public final Builder outboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
            return this;
        }

        public final String getInstanceAccessUrl() {
            return this.instanceAccessUrl;
        }

        public final void setInstanceAccessUrl(String instanceAccessUrl) {
            this.instanceAccessUrl = instanceAccessUrl;
        }

        @Override
        public final Builder instanceAccessUrl(String instanceAccessUrl) {
            this.instanceAccessUrl = instanceAccessUrl;
            return this;
        }

        public InstanceSummary build() {
            return new InstanceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder identityManagementType(String var1);

        public Builder identityManagementType(DirectoryType var1);

        public Builder instanceAlias(String var1);

        public Builder createdTime(Instant var1);

        public Builder serviceRole(String var1);

        public Builder instanceStatus(String var1);

        public Builder instanceStatus(InstanceStatus var1);

        public Builder inboundCallsEnabled(Boolean var1);

        public Builder outboundCallsEnabled(Boolean var1);

        public Builder instanceAccessUrl(String var1);
    }
}

