/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.IntervalPeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricInterval
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricInterval> {
    private static final SdkField<String> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Interval").getter(MetricInterval.getter(MetricInterval::intervalAsString)).setter(MetricInterval.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MetricInterval.getter(MetricInterval::startTime)).setter(MetricInterval.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(MetricInterval.getter(MetricInterval::endTime)).setter(MetricInterval.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricInterval.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String interval;
    private final Instant startTime;
    private final Instant endTime;

    private MetricInterval(BuilderImpl builder) {
        this.interval = builder.interval;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final IntervalPeriod interval() {
        return IntervalPeriod.fromValue(this.interval);
    }

    public final String intervalAsString() {
        return this.interval;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricInterval)) {
            return false;
        }
        MetricInterval other = (MetricInterval)obj;
        return Objects.equals(this.intervalAsString(), other.intervalAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"MetricInterval").add("Interval", (Object)this.intervalAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.intervalAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Interval", INTERVAL_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricInterval, T> g) {
        return obj -> g.apply((MetricInterval)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String interval;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricInterval model) {
            this.interval(model.interval);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getInterval() {
            return this.interval;
        }

        public final void setInterval(String interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public final Builder interval(IntervalPeriod interval) {
            this.interval(interval == null ? null : interval.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public MetricInterval build() {
            return new MetricInterval(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricInterval> {
        public Builder interval(String var1);

        public Builder interval(IntervalPeriod var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

