/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.MetricFilterV2;
import software.amazon.awssdk.services.connect.model.MetricFiltersV2ListCopier;
import software.amazon.awssdk.services.connect.model.ThresholdCollectionsCopier;
import software.amazon.awssdk.services.connect.model.ThresholdV2;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricV2> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MetricV2.getter(MetricV2::name)).setter(MetricV2.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<ThresholdV2>> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Threshold").getter(MetricV2.getter(MetricV2::threshold)).setter(MetricV2.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThresholdV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricFilterV2>> METRIC_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricFilters").getter(MetricV2.getter(MetricV2::metricFilters)).setter(MetricV2.setter(Builder::metricFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricFilterV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, THRESHOLD_FIELD, METRIC_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricV2.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<ThresholdV2> threshold;
    private final List<MetricFilterV2> metricFilters;

    private MetricV2(BuilderImpl builder) {
        this.name = builder.name;
        this.threshold = builder.threshold;
        this.metricFilters = builder.metricFilters;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasThreshold() {
        return this.threshold != null && !(this.threshold instanceof SdkAutoConstructList);
    }

    public final List<ThresholdV2> threshold() {
        return this.threshold;
    }

    public final boolean hasMetricFilters() {
        return this.metricFilters != null && !(this.metricFilters instanceof SdkAutoConstructList);
    }

    public final List<MetricFilterV2> metricFilters() {
        return this.metricFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreshold() ? this.threshold() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricFilters() ? this.metricFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricV2)) {
            return false;
        }
        MetricV2 other = (MetricV2)obj;
        return Objects.equals(this.name(), other.name()) && this.hasThreshold() == other.hasThreshold() && Objects.equals(this.threshold(), other.threshold()) && this.hasMetricFilters() == other.hasMetricFilters() && Objects.equals(this.metricFilters(), other.metricFilters());
    }

    public final String toString() {
        return ToString.builder((String)"MetricV2").add("Name", (Object)this.name()).add("Threshold", this.hasThreshold() ? this.threshold() : null).add("MetricFilters", this.hasMetricFilters() ? this.metricFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "MetricFilters": {
                return Optional.ofNullable(clazz.cast(this.metricFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Threshold", THRESHOLD_FIELD);
        map.put("MetricFilters", METRIC_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricV2, T> g) {
        return obj -> g.apply((MetricV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<ThresholdV2> threshold = DefaultSdkAutoConstructList.getInstance();
        private List<MetricFilterV2> metricFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricV2 model) {
            this.name(model.name);
            this.threshold(model.threshold);
            this.metricFilters(model.metricFilters);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ThresholdV2.Builder> getThreshold() {
            List<ThresholdV2.Builder> result = ThresholdCollectionsCopier.copyToBuilder(this.threshold);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreshold(Collection<ThresholdV2.BuilderImpl> threshold) {
            this.threshold = ThresholdCollectionsCopier.copyFromBuilder(threshold);
        }

        @Override
        public final Builder threshold(Collection<ThresholdV2> threshold) {
            this.threshold = ThresholdCollectionsCopier.copy(threshold);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threshold(ThresholdV2 ... threshold) {
            this.threshold(Arrays.asList(threshold));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threshold(Consumer<ThresholdV2.Builder> ... threshold) {
            this.threshold(Stream.of(threshold).map(c -> (ThresholdV2)((ThresholdV2.Builder)ThresholdV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MetricFilterV2.Builder> getMetricFilters() {
            List<MetricFilterV2.Builder> result = MetricFiltersV2ListCopier.copyToBuilder(this.metricFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricFilters(Collection<MetricFilterV2.BuilderImpl> metricFilters) {
            this.metricFilters = MetricFiltersV2ListCopier.copyFromBuilder(metricFilters);
        }

        @Override
        public final Builder metricFilters(Collection<MetricFilterV2> metricFilters) {
            this.metricFilters = MetricFiltersV2ListCopier.copy(metricFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilters(MetricFilterV2 ... metricFilters) {
            this.metricFilters(Arrays.asList(metricFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilters(Consumer<MetricFilterV2.Builder> ... metricFilters) {
            this.metricFilters(Stream.of(metricFilters).map(c -> (MetricFilterV2)((MetricFilterV2.Builder)MetricFilterV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetricV2 build() {
            return new MetricV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricV2> {
        public Builder name(String var1);

        public Builder threshold(Collection<ThresholdV2> var1);

        public Builder threshold(ThresholdV2 ... var1);

        public Builder threshold(Consumer<ThresholdV2.Builder> ... var1);

        public Builder metricFilters(Collection<MetricFilterV2> var1);

        public Builder metricFilters(MetricFilterV2 ... var1);

        public Builder metricFilters(Consumer<MetricFilterV2.Builder> ... var1);
    }
}

