/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicateInstanceRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, ReplicateInstanceRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ReplicateInstanceRequest.getter(ReplicateInstanceRequest::instanceId)).setter(ReplicateInstanceRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaRegion").getter(ReplicateInstanceRequest.getter(ReplicateInstanceRequest::replicaRegion)).setter(ReplicateInstanceRequest.setter(Builder::replicaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaRegion").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ReplicateInstanceRequest.getter(ReplicateInstanceRequest::clientToken)).setter(ReplicateInstanceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> REPLICA_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaAlias").getter(ReplicateInstanceRequest.getter(ReplicateInstanceRequest::replicaAlias)).setter(ReplicateInstanceRequest.setter(Builder::replicaAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, REPLICA_REGION_FIELD, CLIENT_TOKEN_FIELD, REPLICA_ALIAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicateInstanceRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String replicaRegion;
    private final String clientToken;
    private final String replicaAlias;

    private ReplicateInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.replicaRegion = builder.replicaRegion;
        this.clientToken = builder.clientToken;
        this.replicaAlias = builder.replicaAlias;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String replicaRegion() {
        return this.replicaRegion;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String replicaAlias() {
        return this.replicaAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicateInstanceRequest)) {
            return false;
        }
        ReplicateInstanceRequest other = (ReplicateInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.replicaRegion(), other.replicaRegion()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.replicaAlias(), other.replicaAlias());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicateInstanceRequest").add("InstanceId", (Object)this.instanceId()).add("ReplicaRegion", (Object)this.replicaRegion()).add("ClientToken", (Object)this.clientToken()).add("ReplicaAlias", (Object)(this.replicaAlias() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ReplicaRegion": {
                return Optional.ofNullable(clazz.cast(this.replicaRegion()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ReplicaAlias": {
                return Optional.ofNullable(clazz.cast(this.replicaAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ReplicaRegion", REPLICA_REGION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ReplicaAlias", REPLICA_ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicateInstanceRequest, T> g) {
        return obj -> g.apply((ReplicateInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String replicaRegion;
        private String clientToken;
        private String replicaAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicateInstanceRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.replicaRegion(model.replicaRegion);
            this.clientToken(model.clientToken);
            this.replicaAlias(model.replicaAlias);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getReplicaRegion() {
            return this.replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getReplicaAlias() {
            return this.replicaAlias;
        }

        public final void setReplicaAlias(String replicaAlias) {
            this.replicaAlias = replicaAlias;
        }

        @Override
        public final Builder replicaAlias(String replicaAlias) {
            this.replicaAlias = replicaAlias;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplicateInstanceRequest build() {
            return new ReplicateInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReplicateInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder replicaRegion(String var1);

        public Builder clientToken(String var1);

        public Builder replicaAlias(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

