/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceType {
    CONTACT("CONTACT"),
    CONTACT_FLOW("CONTACT_FLOW"),
    INSTANCE("INSTANCE"),
    PARTICIPANT("PARTICIPANT"),
    HIERARCHY_LEVEL("HIERARCHY_LEVEL"),
    HIERARCHY_GROUP("HIERARCHY_GROUP"),
    USER("USER"),
    PHONE_NUMBER("PHONE_NUMBER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceType> VALUE_MAP;
    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        EnumSet<ResourceType> knownValues = EnumSet.allOf(ResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceType.class, ResourceType::toString);
    }
}

