/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AiUseCase {
    AGENT_ASSISTANCE("AgentAssistance"),
    SELF_SERVICE("SelfService"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AiUseCase> VALUE_MAP;
    private final String value;

    private AiUseCase(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AiUseCase fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AiUseCase> knownValues() {
        EnumSet<AiUseCase> knownValues = EnumSet.allOf(AiUseCase.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AiUseCase.class, AiUseCase::toString);
    }
}

