/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AliasConfiguration;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateEmailAddressAliasRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, AssociateEmailAddressAliasRequest> {
    private static final SdkField<String> EMAIL_ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddressId").getter(AssociateEmailAddressAliasRequest.getter(AssociateEmailAddressAliasRequest::emailAddressId)).setter(AssociateEmailAddressAliasRequest.setter(Builder::emailAddressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailAddressId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(AssociateEmailAddressAliasRequest.getter(AssociateEmailAddressAliasRequest::instanceId)).setter(AssociateEmailAddressAliasRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<AliasConfiguration> ALIAS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AliasConfiguration").getter(AssociateEmailAddressAliasRequest.getter(AssociateEmailAddressAliasRequest::aliasConfiguration)).setter(AssociateEmailAddressAliasRequest.setter(Builder::aliasConfiguration)).constructor(AliasConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AssociateEmailAddressAliasRequest.getter(AssociateEmailAddressAliasRequest::clientToken)).setter(AssociateEmailAddressAliasRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_ID_FIELD, INSTANCE_ID_FIELD, ALIAS_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateEmailAddressAliasRequest.memberNameToFieldInitializer();
    private final String emailAddressId;
    private final String instanceId;
    private final AliasConfiguration aliasConfiguration;
    private final String clientToken;

    private AssociateEmailAddressAliasRequest(BuilderImpl builder) {
        super(builder);
        this.emailAddressId = builder.emailAddressId;
        this.instanceId = builder.instanceId;
        this.aliasConfiguration = builder.aliasConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final String emailAddressId() {
        return this.emailAddressId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final AliasConfiguration aliasConfiguration() {
        return this.aliasConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateEmailAddressAliasRequest)) {
            return false;
        }
        AssociateEmailAddressAliasRequest other = (AssociateEmailAddressAliasRequest)((Object)obj);
        return Objects.equals(this.emailAddressId(), other.emailAddressId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.aliasConfiguration(), other.aliasConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateEmailAddressAliasRequest").add("EmailAddressId", (Object)this.emailAddressId()).add("InstanceId", (Object)this.instanceId()).add("AliasConfiguration", (Object)this.aliasConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailAddressId": {
                return Optional.ofNullable(clazz.cast(this.emailAddressId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AliasConfiguration": {
                return Optional.ofNullable(clazz.cast(this.aliasConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EmailAddressId", EMAIL_ADDRESS_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AliasConfiguration", ALIAS_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateEmailAddressAliasRequest, T> g) {
        return obj -> g.apply((AssociateEmailAddressAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String emailAddressId;
        private String instanceId;
        private AliasConfiguration aliasConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateEmailAddressAliasRequest model) {
            super(model);
            this.emailAddressId(model.emailAddressId);
            this.instanceId(model.instanceId);
            this.aliasConfiguration(model.aliasConfiguration);
            this.clientToken(model.clientToken);
        }

        public final String getEmailAddressId() {
            return this.emailAddressId;
        }

        public final void setEmailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
        }

        @Override
        public final Builder emailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final AliasConfiguration.Builder getAliasConfiguration() {
            return this.aliasConfiguration != null ? this.aliasConfiguration.toBuilder() : null;
        }

        public final void setAliasConfiguration(AliasConfiguration.BuilderImpl aliasConfiguration) {
            this.aliasConfiguration = aliasConfiguration != null ? aliasConfiguration.build() : null;
        }

        @Override
        public final Builder aliasConfiguration(AliasConfiguration aliasConfiguration) {
            this.aliasConfiguration = aliasConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateEmailAddressAliasRequest build() {
            return new AssociateEmailAddressAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateEmailAddressAliasRequest> {
        public Builder emailAddressId(String var1);

        public Builder instanceId(String var1);

        public Builder aliasConfiguration(AliasConfiguration var1);

        default public Builder aliasConfiguration(Consumer<AliasConfiguration.Builder> aliasConfiguration) {
            return this.aliasConfiguration((AliasConfiguration)((AliasConfiguration.Builder)AliasConfiguration.builder().applyMutation(aliasConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

