/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataTableLockVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataTableLockVersion> {
    private static final SdkField<String> DATA_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTable").getter(DataTableLockVersion.getter(DataTableLockVersion::dataTable)).setter(DataTableLockVersion.setter(Builder::dataTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTable").build()}).build();
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(DataTableLockVersion.getter(DataTableLockVersion::attribute)).setter(DataTableLockVersion.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final SdkField<String> PRIMARY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryValues").getter(DataTableLockVersion.getter(DataTableLockVersion::primaryValues)).setter(DataTableLockVersion.setter(Builder::primaryValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(DataTableLockVersion.getter(DataTableLockVersion::value)).setter(DataTableLockVersion.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TABLE_FIELD, ATTRIBUTE_FIELD, PRIMARY_VALUES_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataTableLockVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataTable;
    private final String attribute;
    private final String primaryValues;
    private final String value;

    private DataTableLockVersion(BuilderImpl builder) {
        this.dataTable = builder.dataTable;
        this.attribute = builder.attribute;
        this.primaryValues = builder.primaryValues;
        this.value = builder.value;
    }

    public final String dataTable() {
        return this.dataTable;
    }

    public final String attribute() {
        return this.attribute;
    }

    public final String primaryValues() {
        return this.primaryValues;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableLockVersion)) {
            return false;
        }
        DataTableLockVersion other = (DataTableLockVersion)obj;
        return Objects.equals(this.dataTable(), other.dataTable()) && Objects.equals(this.attribute(), other.attribute()) && Objects.equals(this.primaryValues(), other.primaryValues()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"DataTableLockVersion").add("DataTable", (Object)this.dataTable()).add("Attribute", (Object)this.attribute()).add("PrimaryValues", (Object)this.primaryValues()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataTable": {
                return Optional.ofNullable(clazz.cast(this.dataTable()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
            case "PrimaryValues": {
                return Optional.ofNullable(clazz.cast(this.primaryValues()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataTable", DATA_TABLE_FIELD);
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableLockVersion, T> g) {
        return obj -> g.apply((DataTableLockVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataTable;
        private String attribute;
        private String primaryValues;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableLockVersion model) {
            this.dataTable(model.dataTable);
            this.attribute(model.attribute);
            this.primaryValues(model.primaryValues);
            this.value(model.value);
        }

        public final String getDataTable() {
            return this.dataTable;
        }

        public final void setDataTable(String dataTable) {
            this.dataTable = dataTable;
        }

        @Override
        public final Builder dataTable(String dataTable) {
            this.dataTable = dataTable;
            return this;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final String getPrimaryValues() {
            return this.primaryValues;
        }

        public final void setPrimaryValues(String primaryValues) {
            this.primaryValues = primaryValues;
        }

        @Override
        public final Builder primaryValues(String primaryValues) {
            this.primaryValues = primaryValues;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public DataTableLockVersion build() {
            return new DataTableLockVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataTableLockVersion> {
        public Builder dataTable(String var1);

        public Builder attribute(String var1);

        public Builder primaryValues(String var1);

        public Builder value(String var1);
    }
}

