/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.ChatStreamingConfiguration;
import software.amazon.awssdk.services.connect.model.ParticipantDetails;
import software.amazon.awssdk.services.connect.model.SupportedMessagingContentTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NewSessionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NewSessionDetails> {
    private static final SdkField<List<String>> SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedMessagingContentTypes").getter(NewSessionDetails.getter(NewSessionDetails::supportedMessagingContentTypes)).setter(NewSessionDetails.setter(Builder::supportedMessagingContentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedMessagingContentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ParticipantDetails> PARTICIPANT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParticipantDetails").getter(NewSessionDetails.getter(NewSessionDetails::participantDetails)).setter(NewSessionDetails.setter(Builder::participantDetails)).constructor(ParticipantDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantDetails").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(NewSessionDetails.getter(NewSessionDetails::attributes)).setter(NewSessionDetails.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ChatStreamingConfiguration> STREAMING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingConfiguration").getter(NewSessionDetails.getter(NewSessionDetails::streamingConfiguration)).setter(NewSessionDetails.setter(Builder::streamingConfiguration)).constructor(ChatStreamingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD, PARTICIPANT_DETAILS_FIELD, ATTRIBUTES_FIELD, STREAMING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NewSessionDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> supportedMessagingContentTypes;
    private final ParticipantDetails participantDetails;
    private final Map<String, String> attributes;
    private final ChatStreamingConfiguration streamingConfiguration;

    private NewSessionDetails(BuilderImpl builder) {
        this.supportedMessagingContentTypes = builder.supportedMessagingContentTypes;
        this.participantDetails = builder.participantDetails;
        this.attributes = builder.attributes;
        this.streamingConfiguration = builder.streamingConfiguration;
    }

    public final boolean hasSupportedMessagingContentTypes() {
        return this.supportedMessagingContentTypes != null && !(this.supportedMessagingContentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedMessagingContentTypes() {
        return this.supportedMessagingContentTypes;
    }

    public final ParticipantDetails participantDetails() {
        return this.participantDetails;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final ChatStreamingConfiguration streamingConfiguration() {
        return this.streamingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedMessagingContentTypes() ? this.supportedMessagingContentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.participantDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewSessionDetails)) {
            return false;
        }
        NewSessionDetails other = (NewSessionDetails)obj;
        return this.hasSupportedMessagingContentTypes() == other.hasSupportedMessagingContentTypes() && Objects.equals(this.supportedMessagingContentTypes(), other.supportedMessagingContentTypes()) && Objects.equals(this.participantDetails(), other.participantDetails()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.streamingConfiguration(), other.streamingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"NewSessionDetails").add("SupportedMessagingContentTypes", this.hasSupportedMessagingContentTypes() ? this.supportedMessagingContentTypes() : null).add("ParticipantDetails", (Object)this.participantDetails()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("StreamingConfiguration", (Object)this.streamingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SupportedMessagingContentTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedMessagingContentTypes()));
            }
            case "ParticipantDetails": {
                return Optional.ofNullable(clazz.cast(this.participantDetails()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "StreamingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.streamingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SupportedMessagingContentTypes", SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD);
        map.put("ParticipantDetails", PARTICIPANT_DETAILS_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("StreamingConfiguration", STREAMING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NewSessionDetails, T> g) {
        return obj -> g.apply((NewSessionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> supportedMessagingContentTypes = DefaultSdkAutoConstructList.getInstance();
        private ParticipantDetails participantDetails;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private ChatStreamingConfiguration streamingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NewSessionDetails model) {
            this.supportedMessagingContentTypes(model.supportedMessagingContentTypes);
            this.participantDetails(model.participantDetails);
            this.attributes(model.attributes);
            this.streamingConfiguration(model.streamingConfiguration);
        }

        public final Collection<String> getSupportedMessagingContentTypes() {
            if (this.supportedMessagingContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedMessagingContentTypes;
        }

        public final void setSupportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
        }

        @Override
        public final Builder supportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedMessagingContentTypes(String ... supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes(Arrays.asList(supportedMessagingContentTypes));
            return this;
        }

        public final ParticipantDetails.Builder getParticipantDetails() {
            return this.participantDetails != null ? this.participantDetails.toBuilder() : null;
        }

        public final void setParticipantDetails(ParticipantDetails.BuilderImpl participantDetails) {
            this.participantDetails = participantDetails != null ? participantDetails.build() : null;
        }

        @Override
        public final Builder participantDetails(ParticipantDetails participantDetails) {
            this.participantDetails = participantDetails;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final ChatStreamingConfiguration.Builder getStreamingConfiguration() {
            return this.streamingConfiguration != null ? this.streamingConfiguration.toBuilder() : null;
        }

        public final void setStreamingConfiguration(ChatStreamingConfiguration.BuilderImpl streamingConfiguration) {
            this.streamingConfiguration = streamingConfiguration != null ? streamingConfiguration.build() : null;
        }

        @Override
        public final Builder streamingConfiguration(ChatStreamingConfiguration streamingConfiguration) {
            this.streamingConfiguration = streamingConfiguration;
            return this;
        }

        public NewSessionDetails build() {
            return new NewSessionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NewSessionDetails> {
        public Builder supportedMessagingContentTypes(Collection<String> var1);

        public Builder supportedMessagingContentTypes(String ... var1);

        public Builder participantDetails(ParticipantDetails var1);

        default public Builder participantDetails(Consumer<ParticipantDetails.Builder> participantDetails) {
            return this.participantDetails((ParticipantDetails)((ParticipantDetails.Builder)ParticipantDetails.builder().applyMutation(participantDetails)).build());
        }

        public Builder attributes(Map<String, String> var1);

        public Builder streamingConfiguration(ChatStreamingConfiguration var1);

        default public Builder streamingConfiguration(Consumer<ChatStreamingConfiguration.Builder> streamingConfiguration) {
            return this.streamingConfiguration((ChatStreamingConfiguration)((ChatStreamingConfiguration.Builder)ChatStreamingConfiguration.builder().applyMutation(streamingConfiguration)).build());
        }
    }
}

