/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ResponseMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipantConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipantConfiguration> {
    private static final SdkField<String> RESPONSE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResponseMode").getter(ParticipantConfiguration.getter(ParticipantConfiguration::responseModeAsString)).setter(ParticipantConfiguration.setter(Builder::responseMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParticipantConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String responseMode;

    private ParticipantConfiguration(BuilderImpl builder) {
        this.responseMode = builder.responseMode;
    }

    public final ResponseMode responseMode() {
        return ResponseMode.fromValue(this.responseMode);
    }

    public final String responseModeAsString() {
        return this.responseMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.responseModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantConfiguration)) {
            return false;
        }
        ParticipantConfiguration other = (ParticipantConfiguration)obj;
        return Objects.equals(this.responseModeAsString(), other.responseModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipantConfiguration").add("ResponseMode", (Object)this.responseModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResponseMode": {
                return Optional.ofNullable(clazz.cast(this.responseModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResponseMode", RESPONSE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantConfiguration, T> g) {
        return obj -> g.apply((ParticipantConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String responseMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantConfiguration model) {
            this.responseMode(model.responseMode);
        }

        public final String getResponseMode() {
            return this.responseMode;
        }

        public final void setResponseMode(String responseMode) {
            this.responseMode = responseMode;
        }

        @Override
        public final Builder responseMode(String responseMode) {
            this.responseMode = responseMode;
            return this;
        }

        @Override
        public final Builder responseMode(ResponseMode responseMode) {
            this.responseMode(responseMode == null ? null : responseMode.toString());
            return this;
        }

        public ParticipantConfiguration build() {
            return new ParticipantConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipantConfiguration> {
        public Builder responseMode(String var1);

        public Builder responseMode(ResponseMode var1);
    }
}

