/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.PrimaryValueResponse;
import software.amazon.awssdk.services.connect.model.PrimaryValuesResponseSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordPrimaryValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordPrimaryValue> {
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordId").getter(RecordPrimaryValue.getter(RecordPrimaryValue::recordId)).setter(RecordPrimaryValue.setter(Builder::recordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()}).build();
    private static final SdkField<List<PrimaryValueResponse>> PRIMARY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryValues").getter(RecordPrimaryValue.getter(RecordPrimaryValue::primaryValues)).setter(RecordPrimaryValue.setter(Builder::primaryValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrimaryValueResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(RecordPrimaryValue.getter(RecordPrimaryValue::lastModifiedTime)).setter(RecordPrimaryValue.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(RecordPrimaryValue.getter(RecordPrimaryValue::lastModifiedRegion)).setter(RecordPrimaryValue.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ID_FIELD, PRIMARY_VALUES_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecordPrimaryValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String recordId;
    private final List<PrimaryValueResponse> primaryValues;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private RecordPrimaryValue(BuilderImpl builder) {
        this.recordId = builder.recordId;
        this.primaryValues = builder.primaryValues;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String recordId() {
        return this.recordId;
    }

    public final boolean hasPrimaryValues() {
        return this.primaryValues != null && !(this.primaryValues instanceof SdkAutoConstructList);
    }

    public final List<PrimaryValueResponse> primaryValues() {
        return this.primaryValues;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryValues() ? this.primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordPrimaryValue)) {
            return false;
        }
        RecordPrimaryValue other = (RecordPrimaryValue)obj;
        return Objects.equals(this.recordId(), other.recordId()) && this.hasPrimaryValues() == other.hasPrimaryValues() && Objects.equals(this.primaryValues(), other.primaryValues()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"RecordPrimaryValue").add("RecordId", (Object)this.recordId()).add("PrimaryValues", this.hasPrimaryValues() ? this.primaryValues() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordId": {
                return Optional.ofNullable(clazz.cast(this.recordId()));
            }
            case "PrimaryValues": {
                return Optional.ofNullable(clazz.cast(this.primaryValues()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecordId", RECORD_ID_FIELD);
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordPrimaryValue, T> g) {
        return obj -> g.apply((RecordPrimaryValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordId;
        private List<PrimaryValueResponse> primaryValues = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordPrimaryValue model) {
            this.recordId(model.recordId);
            this.primaryValues(model.primaryValues);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getRecordId() {
            return this.recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final List<PrimaryValueResponse.Builder> getPrimaryValues() {
            List<PrimaryValueResponse.Builder> result = PrimaryValuesResponseSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValueResponse.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesResponseSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValueResponse> primaryValues) {
            this.primaryValues = PrimaryValuesResponseSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValueResponse ... primaryValues) {
            this.primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValueResponse.Builder> ... primaryValues) {
            this.primaryValues(Stream.of(primaryValues).map(c -> (PrimaryValueResponse)((PrimaryValueResponse.Builder)PrimaryValueResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public RecordPrimaryValue build() {
            return new RecordPrimaryValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordPrimaryValue> {
        public Builder recordId(String var1);

        public Builder primaryValues(Collection<PrimaryValueResponse> var1);

        public Builder primaryValues(PrimaryValueResponse ... var1);

        public Builder primaryValues(Consumer<PrimaryValueResponse.Builder> ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

