/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ValidationEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Validation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Validation> {
    private static final SdkField<Integer> MIN_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinLength").getter(Validation.getter(Validation::minLength)).setter(Validation.setter(Builder::minLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinLength").build()}).build();
    private static final SdkField<Integer> MAX_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLength").getter(Validation.getter(Validation::maxLength)).setter(Validation.setter(Builder::maxLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLength").build()}).build();
    private static final SdkField<Integer> MIN_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinValues").getter(Validation.getter(Validation::minValues)).setter(Validation.setter(Builder::minValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValues").build()}).build();
    private static final SdkField<Integer> MAX_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxValues").getter(Validation.getter(Validation::maxValues)).setter(Validation.setter(Builder::maxValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValues").build()}).build();
    private static final SdkField<Boolean> IGNORE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IgnoreCase").getter(Validation.getter(Validation::ignoreCase)).setter(Validation.setter(Builder::ignoreCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreCase").build()}).build();
    private static final SdkField<Double> MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Minimum").getter(Validation.getter(Validation::minimum)).setter(Validation.setter(Builder::minimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()}).build();
    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Maximum").getter(Validation.getter(Validation::maximum)).setter(Validation.setter(Builder::maximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()}).build();
    private static final SdkField<Double> EXCLUSIVE_MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ExclusiveMinimum").getter(Validation.getter(Validation::exclusiveMinimum)).setter(Validation.setter(Builder::exclusiveMinimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveMinimum").build()}).build();
    private static final SdkField<Double> EXCLUSIVE_MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ExclusiveMaximum").getter(Validation.getter(Validation::exclusiveMaximum)).setter(Validation.setter(Builder::exclusiveMaximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveMaximum").build()}).build();
    private static final SdkField<Double> MULTIPLE_OF_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MultipleOf").getter(Validation.getter(Validation::multipleOf)).setter(Validation.setter(Builder::multipleOf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultipleOf").build()}).build();
    private static final SdkField<ValidationEnum> ENUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Enum").getter(Validation.getter(Validation::enumValue)).setter(Validation.setter(Builder::enumValue)).constructor(ValidationEnum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enum").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_LENGTH_FIELD, MAX_LENGTH_FIELD, MIN_VALUES_FIELD, MAX_VALUES_FIELD, IGNORE_CASE_FIELD, MINIMUM_FIELD, MAXIMUM_FIELD, EXCLUSIVE_MINIMUM_FIELD, EXCLUSIVE_MAXIMUM_FIELD, MULTIPLE_OF_FIELD, ENUM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Validation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer minLength;
    private final Integer maxLength;
    private final Integer minValues;
    private final Integer maxValues;
    private final Boolean ignoreCase;
    private final Double minimum;
    private final Double maximum;
    private final Double exclusiveMinimum;
    private final Double exclusiveMaximum;
    private final Double multipleOf;
    private final ValidationEnum enumValue;

    private Validation(BuilderImpl builder) {
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
        this.minValues = builder.minValues;
        this.maxValues = builder.maxValues;
        this.ignoreCase = builder.ignoreCase;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.exclusiveMinimum = builder.exclusiveMinimum;
        this.exclusiveMaximum = builder.exclusiveMaximum;
        this.multipleOf = builder.multipleOf;
        this.enumValue = builder.enumValue;
    }

    public final Integer minLength() {
        return this.minLength;
    }

    public final Integer maxLength() {
        return this.maxLength;
    }

    public final Integer minValues() {
        return this.minValues;
    }

    public final Integer maxValues() {
        return this.maxValues;
    }

    public final Boolean ignoreCase() {
        return this.ignoreCase;
    }

    public final Double minimum() {
        return this.minimum;
    }

    public final Double maximum() {
        return this.maximum;
    }

    public final Double exclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public final Double exclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public final Double multipleOf() {
        return this.multipleOf;
    }

    public final ValidationEnum enumValue() {
        return this.enumValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.minValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreCase());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.multipleOf());
        hashCode = 31 * hashCode + Objects.hashCode(this.enumValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Validation)) {
            return false;
        }
        Validation other = (Validation)obj;
        return Objects.equals(this.minLength(), other.minLength()) && Objects.equals(this.maxLength(), other.maxLength()) && Objects.equals(this.minValues(), other.minValues()) && Objects.equals(this.maxValues(), other.maxValues()) && Objects.equals(this.ignoreCase(), other.ignoreCase()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.exclusiveMinimum(), other.exclusiveMinimum()) && Objects.equals(this.exclusiveMaximum(), other.exclusiveMaximum()) && Objects.equals(this.multipleOf(), other.multipleOf()) && Objects.equals(this.enumValue(), other.enumValue());
    }

    public final String toString() {
        return ToString.builder((String)"Validation").add("MinLength", (Object)this.minLength()).add("MaxLength", (Object)this.maxLength()).add("MinValues", (Object)this.minValues()).add("MaxValues", (Object)this.maxValues()).add("IgnoreCase", (Object)this.ignoreCase()).add("Minimum", (Object)this.minimum()).add("Maximum", (Object)this.maximum()).add("ExclusiveMinimum", (Object)this.exclusiveMinimum()).add("ExclusiveMaximum", (Object)this.exclusiveMaximum()).add("MultipleOf", (Object)this.multipleOf()).add("Enum", (Object)this.enumValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinLength": {
                return Optional.ofNullable(clazz.cast(this.minLength()));
            }
            case "MaxLength": {
                return Optional.ofNullable(clazz.cast(this.maxLength()));
            }
            case "MinValues": {
                return Optional.ofNullable(clazz.cast(this.minValues()));
            }
            case "MaxValues": {
                return Optional.ofNullable(clazz.cast(this.maxValues()));
            }
            case "IgnoreCase": {
                return Optional.ofNullable(clazz.cast(this.ignoreCase()));
            }
            case "Minimum": {
                return Optional.ofNullable(clazz.cast(this.minimum()));
            }
            case "Maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
            case "ExclusiveMinimum": {
                return Optional.ofNullable(clazz.cast(this.exclusiveMinimum()));
            }
            case "ExclusiveMaximum": {
                return Optional.ofNullable(clazz.cast(this.exclusiveMaximum()));
            }
            case "MultipleOf": {
                return Optional.ofNullable(clazz.cast(this.multipleOf()));
            }
            case "Enum": {
                return Optional.ofNullable(clazz.cast(this.enumValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MinLength", MIN_LENGTH_FIELD);
        map.put("MaxLength", MAX_LENGTH_FIELD);
        map.put("MinValues", MIN_VALUES_FIELD);
        map.put("MaxValues", MAX_VALUES_FIELD);
        map.put("IgnoreCase", IGNORE_CASE_FIELD);
        map.put("Minimum", MINIMUM_FIELD);
        map.put("Maximum", MAXIMUM_FIELD);
        map.put("ExclusiveMinimum", EXCLUSIVE_MINIMUM_FIELD);
        map.put("ExclusiveMaximum", EXCLUSIVE_MAXIMUM_FIELD);
        map.put("MultipleOf", MULTIPLE_OF_FIELD);
        map.put("Enum", ENUM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Validation, T> g) {
        return obj -> g.apply((Validation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minLength;
        private Integer maxLength;
        private Integer minValues;
        private Integer maxValues;
        private Boolean ignoreCase;
        private Double minimum;
        private Double maximum;
        private Double exclusiveMinimum;
        private Double exclusiveMaximum;
        private Double multipleOf;
        private ValidationEnum enumValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Validation model) {
            this.minLength(model.minLength);
            this.maxLength(model.maxLength);
            this.minValues(model.minValues);
            this.maxValues(model.maxValues);
            this.ignoreCase(model.ignoreCase);
            this.minimum(model.minimum);
            this.maximum(model.maximum);
            this.exclusiveMinimum(model.exclusiveMinimum);
            this.exclusiveMaximum(model.exclusiveMaximum);
            this.multipleOf(model.multipleOf);
            this.enumValue(model.enumValue);
        }

        public final Integer getMinLength() {
            return this.minLength;
        }

        public final void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        @Override
        public final Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public final Integer getMaxLength() {
            return this.maxLength;
        }

        public final void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public final Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final Integer getMinValues() {
            return this.minValues;
        }

        public final void setMinValues(Integer minValues) {
            this.minValues = minValues;
        }

        @Override
        public final Builder minValues(Integer minValues) {
            this.minValues = minValues;
            return this;
        }

        public final Integer getMaxValues() {
            return this.maxValues;
        }

        public final void setMaxValues(Integer maxValues) {
            this.maxValues = maxValues;
        }

        @Override
        public final Builder maxValues(Integer maxValues) {
            this.maxValues = maxValues;
            return this;
        }

        public final Boolean getIgnoreCase() {
            return this.ignoreCase;
        }

        public final void setIgnoreCase(Boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        @Override
        public final Builder ignoreCase(Boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Double getExclusiveMinimum() {
            return this.exclusiveMinimum;
        }

        public final void setExclusiveMinimum(Double exclusiveMinimum) {
            this.exclusiveMinimum = exclusiveMinimum;
        }

        @Override
        public final Builder exclusiveMinimum(Double exclusiveMinimum) {
            this.exclusiveMinimum = exclusiveMinimum;
            return this;
        }

        public final Double getExclusiveMaximum() {
            return this.exclusiveMaximum;
        }

        public final void setExclusiveMaximum(Double exclusiveMaximum) {
            this.exclusiveMaximum = exclusiveMaximum;
        }

        @Override
        public final Builder exclusiveMaximum(Double exclusiveMaximum) {
            this.exclusiveMaximum = exclusiveMaximum;
            return this;
        }

        public final Double getMultipleOf() {
            return this.multipleOf;
        }

        public final void setMultipleOf(Double multipleOf) {
            this.multipleOf = multipleOf;
        }

        @Override
        public final Builder multipleOf(Double multipleOf) {
            this.multipleOf = multipleOf;
            return this;
        }

        public final ValidationEnum.Builder getEnumValue() {
            return this.enumValue != null ? this.enumValue.toBuilder() : null;
        }

        public final void setEnumValue(ValidationEnum.BuilderImpl enumValue) {
            this.enumValue = enumValue != null ? enumValue.build() : null;
        }

        @Override
        public final Builder enumValue(ValidationEnum enumValue) {
            this.enumValue = enumValue;
            return this;
        }

        public Validation build() {
            return new Validation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Validation> {
        public Builder minLength(Integer var1);

        public Builder maxLength(Integer var1);

        public Builder minValues(Integer var1);

        public Builder maxValues(Integer var1);

        public Builder ignoreCase(Boolean var1);

        public Builder minimum(Double var1);

        public Builder maximum(Double var1);

        public Builder exclusiveMinimum(Double var1);

        public Builder exclusiveMaximum(Double var1);

        public Builder multipleOf(Double var1);

        public Builder enumValue(ValidationEnum var1);

        default public Builder enumValue(Consumer<ValidationEnum.Builder> enumValue) {
            return this.enumValue((ValidationEnum)((ValidationEnum.Builder)ValidationEnum.builder().applyMutation(enumValue)).build());
        }
    }
}

