/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesRequest;
import software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesResponse;

public class EvaluateDataTableValuesIterable
implements SdkIterable<EvaluateDataTableValuesResponse> {
    private final ConnectClient client;
    private final EvaluateDataTableValuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public EvaluateDataTableValuesIterable(ConnectClient client, EvaluateDataTableValuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new EvaluateDataTableValuesResponseFetcher();
    }

    public Iterator<EvaluateDataTableValuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class EvaluateDataTableValuesResponseFetcher
    implements SyncPageFetcher<EvaluateDataTableValuesResponse> {
        private EvaluateDataTableValuesResponseFetcher() {
        }

        public boolean hasNextPage(EvaluateDataTableValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public EvaluateDataTableValuesResponse nextPage(EvaluateDataTableValuesResponse previousPage) {
            if (previousPage == null) {
                return EvaluateDataTableValuesIterable.this.client.evaluateDataTableValues(EvaluateDataTableValuesIterable.this.firstRequest);
            }
            return EvaluateDataTableValuesIterable.this.client.evaluateDataTableValues((EvaluateDataTableValuesRequest)((Object)EvaluateDataTableValuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

