/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchWorkspaceAssociationsRequest;
import software.amazon.awssdk.services.connect.model.SearchWorkspaceAssociationsResponse;
import software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchSummary;

public class SearchWorkspaceAssociationsIterable
implements SdkIterable<SearchWorkspaceAssociationsResponse> {
    private final ConnectClient client;
    private final SearchWorkspaceAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchWorkspaceAssociationsIterable(ConnectClient client, SearchWorkspaceAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchWorkspaceAssociationsResponseFetcher();
    }

    public Iterator<SearchWorkspaceAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkspaceAssociationSearchSummary> workspaceAssociations() {
        Function<SearchWorkspaceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspaceAssociations() != null) {
                return response.workspaceAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchWorkspaceAssociationsResponseFetcher
    implements SyncPageFetcher<SearchWorkspaceAssociationsResponse> {
        private SearchWorkspaceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(SearchWorkspaceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchWorkspaceAssociationsResponse nextPage(SearchWorkspaceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return SearchWorkspaceAssociationsIterable.this.client.searchWorkspaceAssociations(SearchWorkspaceAssociationsIterable.this.firstRequest);
            }
            return SearchWorkspaceAssociationsIterable.this.client.searchWorkspaceAssociations((SearchWorkspaceAssociationsRequest)((Object)SearchWorkspaceAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

