/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.MultiSelectQuestionRuleCategoryAutomationCondition;
import software.amazon.awssdk.services.connect.model.ReferenceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiSelectQuestionRuleCategoryAutomation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiSelectQuestionRuleCategoryAutomation> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(MultiSelectQuestionRuleCategoryAutomation.getter(MultiSelectQuestionRuleCategoryAutomation::category)).setter(MultiSelectQuestionRuleCategoryAutomation.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Condition").getter(MultiSelectQuestionRuleCategoryAutomation.getter(MultiSelectQuestionRuleCategoryAutomation::conditionAsString)).setter(MultiSelectQuestionRuleCategoryAutomation.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()}).build();
    private static final SdkField<List<String>> OPTION_REF_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionRefIds").getter(MultiSelectQuestionRuleCategoryAutomation.getter(MultiSelectQuestionRuleCategoryAutomation::optionRefIds)).setter(MultiSelectQuestionRuleCategoryAutomation.setter(Builder::optionRefIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionRefIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, CONDITION_FIELD, OPTION_REF_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MultiSelectQuestionRuleCategoryAutomation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String category;
    private final String condition;
    private final List<String> optionRefIds;

    private MultiSelectQuestionRuleCategoryAutomation(BuilderImpl builder) {
        this.category = builder.category;
        this.condition = builder.condition;
        this.optionRefIds = builder.optionRefIds;
    }

    public final String category() {
        return this.category;
    }

    public final MultiSelectQuestionRuleCategoryAutomationCondition condition() {
        return MultiSelectQuestionRuleCategoryAutomationCondition.fromValue(this.condition);
    }

    public final String conditionAsString() {
        return this.condition;
    }

    public final boolean hasOptionRefIds() {
        return this.optionRefIds != null && !(this.optionRefIds instanceof SdkAutoConstructList);
    }

    public final List<String> optionRefIds() {
        return this.optionRefIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionRefIds() ? this.optionRefIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiSelectQuestionRuleCategoryAutomation)) {
            return false;
        }
        MultiSelectQuestionRuleCategoryAutomation other = (MultiSelectQuestionRuleCategoryAutomation)obj;
        return Objects.equals(this.category(), other.category()) && Objects.equals(this.conditionAsString(), other.conditionAsString()) && this.hasOptionRefIds() == other.hasOptionRefIds() && Objects.equals(this.optionRefIds(), other.optionRefIds());
    }

    public final String toString() {
        return ToString.builder((String)"MultiSelectQuestionRuleCategoryAutomation").add("Category", (Object)this.category()).add("Condition", (Object)this.conditionAsString()).add("OptionRefIds", this.hasOptionRefIds() ? this.optionRefIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.conditionAsString()));
            }
            case "OptionRefIds": {
                return Optional.ofNullable(clazz.cast(this.optionRefIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Category", CATEGORY_FIELD);
        map.put("Condition", CONDITION_FIELD);
        map.put("OptionRefIds", OPTION_REF_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiSelectQuestionRuleCategoryAutomation, T> g) {
        return obj -> g.apply((MultiSelectQuestionRuleCategoryAutomation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private String condition;
        private List<String> optionRefIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MultiSelectQuestionRuleCategoryAutomation model) {
            this.category(model.category);
            this.condition(model.condition);
            this.optionRefIds(model.optionRefIds);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getCondition() {
            return this.condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(MultiSelectQuestionRuleCategoryAutomationCondition condition) {
            this.condition(condition == null ? null : condition.toString());
            return this;
        }

        public final Collection<String> getOptionRefIds() {
            if (this.optionRefIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.optionRefIds;
        }

        public final void setOptionRefIds(Collection<String> optionRefIds) {
            this.optionRefIds = ReferenceIdListCopier.copy(optionRefIds);
        }

        @Override
        public final Builder optionRefIds(Collection<String> optionRefIds) {
            this.optionRefIds = ReferenceIdListCopier.copy(optionRefIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionRefIds(String ... optionRefIds) {
            this.optionRefIds(Arrays.asList(optionRefIds));
            return this;
        }

        public MultiSelectQuestionRuleCategoryAutomation build() {
            return new MultiSelectQuestionRuleCategoryAutomation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiSelectQuestionRuleCategoryAutomation> {
        public Builder category(String var1);

        public Builder condition(String var1);

        public Builder condition(MultiSelectQuestionRuleCategoryAutomationCondition var1);

        public Builder optionRefIds(Collection<String> var1);

        public Builder optionRefIds(String ... var1);
    }
}

