/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.PredefinedAttributeConfiguration;
import software.amazon.awssdk.services.connect.model.PredefinedAttributePurposeNameListCopier;
import software.amazon.awssdk.services.connect.model.PredefinedAttributeValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredefinedAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredefinedAttribute> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PredefinedAttribute.getter(PredefinedAttribute::name)).setter(PredefinedAttribute.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<PredefinedAttributeValues> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Values").getter(PredefinedAttribute.getter(PredefinedAttribute::values)).setter(PredefinedAttribute.setter(Builder::values)).constructor(PredefinedAttributeValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build()}).build();
    private static final SdkField<List<String>> PURPOSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Purposes").getter(PredefinedAttribute.getter(PredefinedAttribute::purposes)).setter(PredefinedAttribute.setter(Builder::purposes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Purposes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PredefinedAttributeConfiguration> ATTRIBUTE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeConfiguration").getter(PredefinedAttribute.getter(PredefinedAttribute::attributeConfiguration)).setter(PredefinedAttribute.setter(Builder::attributeConfiguration)).constructor(PredefinedAttributeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeConfiguration").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(PredefinedAttribute.getter(PredefinedAttribute::lastModifiedTime)).setter(PredefinedAttribute.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(PredefinedAttribute.getter(PredefinedAttribute::lastModifiedRegion)).setter(PredefinedAttribute.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD, PURPOSES_FIELD, ATTRIBUTE_CONFIGURATION_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PredefinedAttribute.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final PredefinedAttributeValues values;
    private final List<String> purposes;
    private final PredefinedAttributeConfiguration attributeConfiguration;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private PredefinedAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.purposes = builder.purposes;
        this.attributeConfiguration = builder.attributeConfiguration;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String name() {
        return this.name;
    }

    public final PredefinedAttributeValues values() {
        return this.values;
    }

    public final boolean hasPurposes() {
        return this.purposes != null && !(this.purposes instanceof SdkAutoConstructList);
    }

    public final List<String> purposes() {
        return this.purposes;
    }

    public final PredefinedAttributeConfiguration attributeConfiguration() {
        return this.attributeConfiguration;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPurposes() ? this.purposes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedAttribute)) {
            return false;
        }
        PredefinedAttribute other = (PredefinedAttribute)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.values(), other.values()) && this.hasPurposes() == other.hasPurposes() && Objects.equals(this.purposes(), other.purposes()) && Objects.equals(this.attributeConfiguration(), other.attributeConfiguration()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"PredefinedAttribute").add("Name", (Object)this.name()).add("Values", (Object)this.values()).add("Purposes", this.hasPurposes() ? this.purposes() : null).add("AttributeConfiguration", (Object)this.attributeConfiguration()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "Purposes": {
                return Optional.ofNullable(clazz.cast(this.purposes()));
            }
            case "AttributeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.attributeConfiguration()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("Purposes", PURPOSES_FIELD);
        map.put("AttributeConfiguration", ATTRIBUTE_CONFIGURATION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredefinedAttribute, T> g) {
        return obj -> g.apply((PredefinedAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private PredefinedAttributeValues values;
        private List<String> purposes = DefaultSdkAutoConstructList.getInstance();
        private PredefinedAttributeConfiguration attributeConfiguration;
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedAttribute model) {
            this.name(model.name);
            this.values(model.values);
            this.purposes(model.purposes);
            this.attributeConfiguration(model.attributeConfiguration);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PredefinedAttributeValues.Builder getValues() {
            return this.values != null ? this.values.toBuilder() : null;
        }

        public final void setValues(PredefinedAttributeValues.BuilderImpl values) {
            this.values = values != null ? values.build() : null;
        }

        @Override
        public final Builder values(PredefinedAttributeValues values) {
            this.values = values;
            return this;
        }

        public final Collection<String> getPurposes() {
            if (this.purposes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.purposes;
        }

        public final void setPurposes(Collection<String> purposes) {
            this.purposes = PredefinedAttributePurposeNameListCopier.copy(purposes);
        }

        @Override
        public final Builder purposes(Collection<String> purposes) {
            this.purposes = PredefinedAttributePurposeNameListCopier.copy(purposes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purposes(String ... purposes) {
            this.purposes(Arrays.asList(purposes));
            return this;
        }

        public final PredefinedAttributeConfiguration.Builder getAttributeConfiguration() {
            return this.attributeConfiguration != null ? this.attributeConfiguration.toBuilder() : null;
        }

        public final void setAttributeConfiguration(PredefinedAttributeConfiguration.BuilderImpl attributeConfiguration) {
            this.attributeConfiguration = attributeConfiguration != null ? attributeConfiguration.build() : null;
        }

        @Override
        public final Builder attributeConfiguration(PredefinedAttributeConfiguration attributeConfiguration) {
            this.attributeConfiguration = attributeConfiguration;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public PredefinedAttribute build() {
            return new PredefinedAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredefinedAttribute> {
        public Builder name(String var1);

        public Builder values(PredefinedAttributeValues var1);

        default public Builder values(Consumer<PredefinedAttributeValues.Builder> values) {
            return this.values((PredefinedAttributeValues)((PredefinedAttributeValues.Builder)PredefinedAttributeValues.builder().applyMutation(values)).build());
        }

        public Builder purposes(Collection<String> var1);

        public Builder purposes(String ... var1);

        public Builder attributeConfiguration(PredefinedAttributeConfiguration var1);

        default public Builder attributeConfiguration(Consumer<PredefinedAttributeConfiguration.Builder> attributeConfiguration) {
            return this.attributeConfiguration((PredefinedAttributeConfiguration)((PredefinedAttributeConfiguration.Builder)PredefinedAttributeConfiguration.builder().applyMutation(attributeConfiguration)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

