/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.SignInDistribution;
import software.amazon.awssdk.services.connect.model.SignInDistributionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignInConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SignInConfig> {
    private static final SdkField<List<SignInDistribution>> DISTRIBUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Distributions").getter(SignInConfig.getter(SignInConfig::distributions)).setter(SignInConfig.setter(Builder::distributions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SignInDistribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SignInConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<SignInDistribution> distributions;

    private SignInConfig(BuilderImpl builder) {
        this.distributions = builder.distributions;
    }

    public final boolean hasDistributions() {
        return this.distributions != null && !(this.distributions instanceof SdkAutoConstructList);
    }

    public final List<SignInDistribution> distributions() {
        return this.distributions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDistributions() ? this.distributions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignInConfig)) {
            return false;
        }
        SignInConfig other = (SignInConfig)obj;
        return this.hasDistributions() == other.hasDistributions() && Objects.equals(this.distributions(), other.distributions());
    }

    public final String toString() {
        return ToString.builder((String)"SignInConfig").add("Distributions", this.hasDistributions() ? this.distributions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Distributions": {
                return Optional.ofNullable(clazz.cast(this.distributions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<SignInDistribution>>> map = new HashMap<String, SdkField<List<SignInDistribution>>>();
        map.put("Distributions", DISTRIBUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignInConfig, T> g) {
        return obj -> g.apply((SignInConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SignInDistribution> distributions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SignInConfig model) {
            this.distributions(model.distributions);
        }

        public final List<SignInDistribution.Builder> getDistributions() {
            List<SignInDistribution.Builder> result = SignInDistributionListCopier.copyToBuilder(this.distributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistributions(Collection<SignInDistribution.BuilderImpl> distributions) {
            this.distributions = SignInDistributionListCopier.copyFromBuilder(distributions);
        }

        @Override
        public final Builder distributions(Collection<SignInDistribution> distributions) {
            this.distributions = SignInDistributionListCopier.copy(distributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(SignInDistribution ... distributions) {
            this.distributions(Arrays.asList(distributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Consumer<SignInDistribution.Builder> ... distributions) {
            this.distributions(Stream.of(distributions).map(c -> (SignInDistribution)((SignInDistribution.Builder)SignInDistribution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SignInConfig build() {
            return new SignInConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SignInConfig> {
        public Builder distributions(Collection<SignInDistribution> var1);

        public Builder distributions(SignInDistribution ... var1);

        public Builder distributions(Consumer<SignInDistribution.Builder> ... var1);
    }
}

