/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspacePage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspacePage> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(WorkspacePage.getter(WorkspacePage::resourceArn)).setter(WorkspacePage.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Page").getter(WorkspacePage.getter(WorkspacePage::page)).setter(WorkspacePage.setter(Builder::page)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Page").build()}).build();
    private static final SdkField<String> SLUG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Slug").getter(WorkspacePage.getter(WorkspacePage::slug)).setter(WorkspacePage.setter(Builder::slug)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slug").build()}).build();
    private static final SdkField<String> INPUT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputData").getter(WorkspacePage.getter(WorkspacePage::inputData)).setter(WorkspacePage.setter(Builder::inputData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, PAGE_FIELD, SLUG_FIELD, INPUT_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkspacePage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String page;
    private final String slug;
    private final String inputData;

    private WorkspacePage(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.page = builder.page;
        this.slug = builder.slug;
        this.inputData = builder.inputData;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String page() {
        return this.page;
    }

    public final String slug() {
        return this.slug;
    }

    public final String inputData() {
        return this.inputData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.page());
        hashCode = 31 * hashCode + Objects.hashCode(this.slug());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspacePage)) {
            return false;
        }
        WorkspacePage other = (WorkspacePage)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.page(), other.page()) && Objects.equals(this.slug(), other.slug()) && Objects.equals(this.inputData(), other.inputData());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspacePage").add("ResourceArn", (Object)this.resourceArn()).add("Page", (Object)this.page()).add("Slug", (Object)this.slug()).add("InputData", (Object)this.inputData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Page": {
                return Optional.ofNullable(clazz.cast(this.page()));
            }
            case "Slug": {
                return Optional.ofNullable(clazz.cast(this.slug()));
            }
            case "InputData": {
                return Optional.ofNullable(clazz.cast(this.inputData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Page", PAGE_FIELD);
        map.put("Slug", SLUG_FIELD);
        map.put("InputData", INPUT_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspacePage, T> g) {
        return obj -> g.apply((WorkspacePage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String page;
        private String slug;
        private String inputData;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspacePage model) {
            this.resourceArn(model.resourceArn);
            this.page(model.page);
            this.slug(model.slug);
            this.inputData(model.inputData);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPage() {
            return this.page;
        }

        public final void setPage(String page) {
            this.page = page;
        }

        @Override
        public final Builder page(String page) {
            this.page = page;
            return this;
        }

        public final String getSlug() {
            return this.slug;
        }

        public final void setSlug(String slug) {
            this.slug = slug;
        }

        @Override
        public final Builder slug(String slug) {
            this.slug = slug;
            return this;
        }

        public final String getInputData() {
            return this.inputData;
        }

        public final void setInputData(String inputData) {
            this.inputData = inputData;
        }

        @Override
        public final Builder inputData(String inputData) {
            this.inputData = inputData;
            return this;
        }

        public WorkspacePage build() {
            return new WorkspacePage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspacePage> {
        public Builder resourceArn(String var1);

        public Builder page(String var1);

        public Builder slug(String var1);

        public Builder inputData(String var1);
    }
}

