/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListEntitySecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListEntitySecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.SecurityProfileItem;

public class ListEntitySecurityProfilesPublisher
implements SdkPublisher<ListEntitySecurityProfilesResponse> {
    private final ConnectAsyncClient client;
    private final ListEntitySecurityProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEntitySecurityProfilesPublisher(ConnectAsyncClient client, ListEntitySecurityProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEntitySecurityProfilesPublisher(ConnectAsyncClient client, ListEntitySecurityProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEntitySecurityProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEntitySecurityProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityProfileItem> securityProfiles() {
        Function<ListEntitySecurityProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityProfiles() != null) {
                return response.securityProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEntitySecurityProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEntitySecurityProfilesResponseFetcher
    implements AsyncPageFetcher<ListEntitySecurityProfilesResponse> {
        private ListEntitySecurityProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitySecurityProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEntitySecurityProfilesResponse> nextPage(ListEntitySecurityProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListEntitySecurityProfilesPublisher.this.client.listEntitySecurityProfiles(ListEntitySecurityProfilesPublisher.this.firstRequest);
            }
            return ListEntitySecurityProfilesPublisher.this.client.listEntitySecurityProfiles((ListEntitySecurityProfilesRequest)((Object)ListEntitySecurityProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

