/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.FlowModule;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileFlowModulesResponse;

public class ListSecurityProfileFlowModulesIterable
implements SdkIterable<ListSecurityProfileFlowModulesResponse> {
    private final ConnectClient client;
    private final ListSecurityProfileFlowModulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityProfileFlowModulesIterable(ConnectClient client, ListSecurityProfileFlowModulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityProfileFlowModulesResponseFetcher();
    }

    public Iterator<ListSecurityProfileFlowModulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowModule> allowedFlowModules() {
        Function<ListSecurityProfileFlowModulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.allowedFlowModules() != null) {
                return response.allowedFlowModules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityProfileFlowModulesResponseFetcher
    implements SyncPageFetcher<ListSecurityProfileFlowModulesResponse> {
        private ListSecurityProfileFlowModulesResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityProfileFlowModulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityProfileFlowModulesResponse nextPage(ListSecurityProfileFlowModulesResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityProfileFlowModulesIterable.this.client.listSecurityProfileFlowModules(ListSecurityProfileFlowModulesIterable.this.firstRequest);
            }
            return ListSecurityProfileFlowModulesIterable.this.client.listSecurityProfileFlowModules((ListSecurityProfileFlowModulesRequest)((Object)ListSecurityProfileFlowModulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

