/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchWorkspacesRequest;
import software.amazon.awssdk.services.connect.model.SearchWorkspacesResponse;
import software.amazon.awssdk.services.connect.model.WorkspaceSearchSummary;

public class SearchWorkspacesIterable
implements SdkIterable<SearchWorkspacesResponse> {
    private final ConnectClient client;
    private final SearchWorkspacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchWorkspacesIterable(ConnectClient client, SearchWorkspacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchWorkspacesResponseFetcher();
    }

    public Iterator<SearchWorkspacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkspaceSearchSummary> workspaces() {
        Function<SearchWorkspacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspaces() != null) {
                return response.workspaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchWorkspacesResponseFetcher
    implements SyncPageFetcher<SearchWorkspacesResponse> {
        private SearchWorkspacesResponseFetcher() {
        }

        public boolean hasNextPage(SearchWorkspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchWorkspacesResponse nextPage(SearchWorkspacesResponse previousPage) {
            if (previousPage == null) {
                return SearchWorkspacesIterable.this.client.searchWorkspaces(SearchWorkspacesIterable.this.firstRequest);
            }
            return SearchWorkspacesIterable.this.client.searchWorkspaces((SearchWorkspacesRequest)((Object)SearchWorkspacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

