/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcampaigns.model.ConnectCampaignsResponse;
import software.amazon.awssdk.services.connectcampaigns.model.FailedRequest;
import software.amazon.awssdk.services.connectcampaigns.model.FailedRequestListCopier;
import software.amazon.awssdk.services.connectcampaigns.model.SuccessfulRequest;
import software.amazon.awssdk.services.connectcampaigns.model.SuccessfulRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDialRequestBatchResponse
extends ConnectCampaignsResponse
implements ToCopyableBuilder<Builder, PutDialRequestBatchResponse> {
    private static final SdkField<List<SuccessfulRequest>> SUCCESSFUL_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successfulRequests").getter(PutDialRequestBatchResponse.getter(PutDialRequestBatchResponse::successfulRequests)).setter(PutDialRequestBatchResponse.setter(Builder::successfulRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuccessfulRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FailedRequest>> FAILED_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedRequests").getter(PutDialRequestBatchResponse.getter(PutDialRequestBatchResponse::failedRequests)).setter(PutDialRequestBatchResponse.setter(Builder::failedRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_REQUESTS_FIELD, FAILED_REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutDialRequestBatchResponse.memberNameToFieldInitializer();
    private final List<SuccessfulRequest> successfulRequests;
    private final List<FailedRequest> failedRequests;

    private PutDialRequestBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successfulRequests = builder.successfulRequests;
        this.failedRequests = builder.failedRequests;
    }

    public final boolean hasSuccessfulRequests() {
        return this.successfulRequests != null && !(this.successfulRequests instanceof SdkAutoConstructList);
    }

    public final List<SuccessfulRequest> successfulRequests() {
        return this.successfulRequests;
    }

    public final boolean hasFailedRequests() {
        return this.failedRequests != null && !(this.failedRequests instanceof SdkAutoConstructList);
    }

    public final List<FailedRequest> failedRequests() {
        return this.failedRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulRequests() ? this.successfulRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedRequests() ? this.failedRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDialRequestBatchResponse)) {
            return false;
        }
        PutDialRequestBatchResponse other = (PutDialRequestBatchResponse)((Object)obj);
        return this.hasSuccessfulRequests() == other.hasSuccessfulRequests() && Objects.equals(this.successfulRequests(), other.successfulRequests()) && this.hasFailedRequests() == other.hasFailedRequests() && Objects.equals(this.failedRequests(), other.failedRequests());
    }

    public final String toString() {
        return ToString.builder((String)"PutDialRequestBatchResponse").add("SuccessfulRequests", this.hasSuccessfulRequests() ? this.successfulRequests() : null).add("FailedRequests", this.hasFailedRequests() ? this.failedRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "successfulRequests": {
                return Optional.ofNullable(clazz.cast(this.successfulRequests()));
            }
            case "failedRequests": {
                return Optional.ofNullable(clazz.cast(this.failedRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("successfulRequests", SUCCESSFUL_REQUESTS_FIELD);
        map.put("failedRequests", FAILED_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDialRequestBatchResponse, T> g) {
        return obj -> g.apply((PutDialRequestBatchResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCampaignsResponse.BuilderImpl
    implements Builder {
        private List<SuccessfulRequest> successfulRequests = DefaultSdkAutoConstructList.getInstance();
        private List<FailedRequest> failedRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDialRequestBatchResponse model) {
            super(model);
            this.successfulRequests(model.successfulRequests);
            this.failedRequests(model.failedRequests);
        }

        public final List<SuccessfulRequest.Builder> getSuccessfulRequests() {
            List<SuccessfulRequest.Builder> result = SuccessfulRequestListCopier.copyToBuilder(this.successfulRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulRequests(Collection<SuccessfulRequest.BuilderImpl> successfulRequests) {
            this.successfulRequests = SuccessfulRequestListCopier.copyFromBuilder(successfulRequests);
        }

        @Override
        public final Builder successfulRequests(Collection<SuccessfulRequest> successfulRequests) {
            this.successfulRequests = SuccessfulRequestListCopier.copy(successfulRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulRequests(SuccessfulRequest ... successfulRequests) {
            this.successfulRequests(Arrays.asList(successfulRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulRequests(Consumer<SuccessfulRequest.Builder> ... successfulRequests) {
            this.successfulRequests(Stream.of(successfulRequests).map(c -> (SuccessfulRequest)((SuccessfulRequest.Builder)SuccessfulRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FailedRequest.Builder> getFailedRequests() {
            List<FailedRequest.Builder> result = FailedRequestListCopier.copyToBuilder(this.failedRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedRequests(Collection<FailedRequest.BuilderImpl> failedRequests) {
            this.failedRequests = FailedRequestListCopier.copyFromBuilder(failedRequests);
        }

        @Override
        public final Builder failedRequests(Collection<FailedRequest> failedRequests) {
            this.failedRequests = FailedRequestListCopier.copy(failedRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(FailedRequest ... failedRequests) {
            this.failedRequests(Arrays.asList(failedRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(Consumer<FailedRequest.Builder> ... failedRequests) {
            this.failedRequests(Stream.of(failedRequests).map(c -> (FailedRequest)((FailedRequest.Builder)FailedRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutDialRequestBatchResponse build() {
            return new PutDialRequestBatchResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectCampaignsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDialRequestBatchResponse> {
        public Builder successfulRequests(Collection<SuccessfulRequest> var1);

        public Builder successfulRequests(SuccessfulRequest ... var1);

        public Builder successfulRequests(Consumer<SuccessfulRequest.Builder> ... var1);

        public Builder failedRequests(Collection<FailedRequest> var1);

        public Builder failedRequests(FailedRequest ... var1);

        public Builder failedRequests(Consumer<FailedRequest.Builder> ... var1);
    }
}

