/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaignsv2.model.AnswerMachineDetectionConfig;
import software.amazon.awssdk.services.connectcampaignsv2.model.AttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelephonyChannelSubtypeParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelephonyChannelSubtypeParameters> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationPhoneNumber").getter(TelephonyChannelSubtypeParameters.getter(TelephonyChannelSubtypeParameters::destinationPhoneNumber)).setter(TelephonyChannelSubtypeParameters.setter(Builder::destinationPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPhoneNumber").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(TelephonyChannelSubtypeParameters.getter(TelephonyChannelSubtypeParameters::attributes)).setter(TelephonyChannelSubtypeParameters.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECT_SOURCE_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectSourcePhoneNumber").getter(TelephonyChannelSubtypeParameters.getter(TelephonyChannelSubtypeParameters::connectSourcePhoneNumber)).setter(TelephonyChannelSubtypeParameters.setter(Builder::connectSourcePhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectSourcePhoneNumber").build()}).build();
    private static final SdkField<AnswerMachineDetectionConfig> ANSWER_MACHINE_DETECTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("answerMachineDetectionConfig").getter(TelephonyChannelSubtypeParameters.getter(TelephonyChannelSubtypeParameters::answerMachineDetectionConfig)).setter(TelephonyChannelSubtypeParameters.setter(Builder::answerMachineDetectionConfig)).constructor(AnswerMachineDetectionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("answerMachineDetectionConfig").build()}).build();
    private static final SdkField<Integer> RING_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ringTimeout").getter(TelephonyChannelSubtypeParameters.getter(TelephonyChannelSubtypeParameters::ringTimeout)).setter(TelephonyChannelSubtypeParameters.setter(Builder::ringTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ringTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PHONE_NUMBER_FIELD, ATTRIBUTES_FIELD, CONNECT_SOURCE_PHONE_NUMBER_FIELD, ANSWER_MACHINE_DETECTION_CONFIG_FIELD, RING_TIMEOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TelephonyChannelSubtypeParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationPhoneNumber;
    private final Map<String, String> attributes;
    private final String connectSourcePhoneNumber;
    private final AnswerMachineDetectionConfig answerMachineDetectionConfig;
    private final Integer ringTimeout;

    private TelephonyChannelSubtypeParameters(BuilderImpl builder) {
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.attributes = builder.attributes;
        this.connectSourcePhoneNumber = builder.connectSourcePhoneNumber;
        this.answerMachineDetectionConfig = builder.answerMachineDetectionConfig;
        this.ringTimeout = builder.ringTimeout;
    }

    public final String destinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String connectSourcePhoneNumber() {
        return this.connectSourcePhoneNumber;
    }

    public final AnswerMachineDetectionConfig answerMachineDetectionConfig() {
        return this.answerMachineDetectionConfig;
    }

    public final Integer ringTimeout() {
        return this.ringTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectSourcePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.answerMachineDetectionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ringTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelephonyChannelSubtypeParameters)) {
            return false;
        }
        TelephonyChannelSubtypeParameters other = (TelephonyChannelSubtypeParameters)obj;
        return Objects.equals(this.destinationPhoneNumber(), other.destinationPhoneNumber()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.connectSourcePhoneNumber(), other.connectSourcePhoneNumber()) && Objects.equals(this.answerMachineDetectionConfig(), other.answerMachineDetectionConfig()) && Objects.equals(this.ringTimeout(), other.ringTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"TelephonyChannelSubtypeParameters").add("DestinationPhoneNumber", (Object)(this.destinationPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Attributes", (Object)(this.attributes() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectSourcePhoneNumber", (Object)this.connectSourcePhoneNumber()).add("AnswerMachineDetectionConfig", (Object)this.answerMachineDetectionConfig()).add("RingTimeout", (Object)this.ringTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.destinationPhoneNumber()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "connectSourcePhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.connectSourcePhoneNumber()));
            }
            case "answerMachineDetectionConfig": {
                return Optional.ofNullable(clazz.cast(this.answerMachineDetectionConfig()));
            }
            case "ringTimeout": {
                return Optional.ofNullable(clazz.cast(this.ringTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("connectSourcePhoneNumber", CONNECT_SOURCE_PHONE_NUMBER_FIELD);
        map.put("answerMachineDetectionConfig", ANSWER_MACHINE_DETECTION_CONFIG_FIELD);
        map.put("ringTimeout", RING_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelephonyChannelSubtypeParameters, T> g) {
        return obj -> g.apply((TelephonyChannelSubtypeParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationPhoneNumber;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String connectSourcePhoneNumber;
        private AnswerMachineDetectionConfig answerMachineDetectionConfig;
        private Integer ringTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(TelephonyChannelSubtypeParameters model) {
            this.destinationPhoneNumber(model.destinationPhoneNumber);
            this.attributes(model.attributes);
            this.connectSourcePhoneNumber(model.connectSourcePhoneNumber);
            this.answerMachineDetectionConfig(model.answerMachineDetectionConfig);
            this.ringTimeout(model.ringTimeout);
        }

        public final String getDestinationPhoneNumber() {
            return this.destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final String getConnectSourcePhoneNumber() {
            return this.connectSourcePhoneNumber;
        }

        public final void setConnectSourcePhoneNumber(String connectSourcePhoneNumber) {
            this.connectSourcePhoneNumber = connectSourcePhoneNumber;
        }

        @Override
        public final Builder connectSourcePhoneNumber(String connectSourcePhoneNumber) {
            this.connectSourcePhoneNumber = connectSourcePhoneNumber;
            return this;
        }

        public final AnswerMachineDetectionConfig.Builder getAnswerMachineDetectionConfig() {
            return this.answerMachineDetectionConfig != null ? this.answerMachineDetectionConfig.toBuilder() : null;
        }

        public final void setAnswerMachineDetectionConfig(AnswerMachineDetectionConfig.BuilderImpl answerMachineDetectionConfig) {
            this.answerMachineDetectionConfig = answerMachineDetectionConfig != null ? answerMachineDetectionConfig.build() : null;
        }

        @Override
        public final Builder answerMachineDetectionConfig(AnswerMachineDetectionConfig answerMachineDetectionConfig) {
            this.answerMachineDetectionConfig = answerMachineDetectionConfig;
            return this;
        }

        public final Integer getRingTimeout() {
            return this.ringTimeout;
        }

        public final void setRingTimeout(Integer ringTimeout) {
            this.ringTimeout = ringTimeout;
        }

        @Override
        public final Builder ringTimeout(Integer ringTimeout) {
            this.ringTimeout = ringTimeout;
            return this;
        }

        public TelephonyChannelSubtypeParameters build() {
            return new TelephonyChannelSubtypeParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelephonyChannelSubtypeParameters> {
        public Builder destinationPhoneNumber(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder connectSourcePhoneNumber(String var1);

        public Builder answerMachineDetectionConfig(AnswerMachineDetectionConfig var1);

        default public Builder answerMachineDetectionConfig(Consumer<AnswerMachineDetectionConfig.Builder> answerMachineDetectionConfig) {
            return this.answerMachineDetectionConfig((AnswerMachineDetectionConfig)((AnswerMachineDetectionConfig.Builder)AnswerMachineDetectionConfig.builder().applyMutation(answerMachineDetectionConfig)).build());
        }

        public Builder ringTimeout(Integer var1);
    }
}

