/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.ContactFilterChannelListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactFilter> {
    private static final SdkField<List<String>> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("channel").getter(ContactFilter.getter(ContactFilter::channel)).setter(ContactFilter.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactArn").getter(ContactFilter.getter(ContactFilter::contactArn)).setter(ContactFilter.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, CONTACT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> channel;
    private final String contactArn;

    private ContactFilter(BuilderImpl builder) {
        this.channel = builder.channel;
        this.contactArn = builder.contactArn;
    }

    public final boolean hasChannel() {
        return this.channel != null && !(this.channel instanceof SdkAutoConstructList);
    }

    public final List<String> channel() {
        return this.channel;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannel() ? this.channel() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFilter)) {
            return false;
        }
        ContactFilter other = (ContactFilter)obj;
        return this.hasChannel() == other.hasChannel() && Objects.equals(this.channel(), other.channel()) && Objects.equals(this.contactArn(), other.contactArn());
    }

    public final String toString() {
        return ToString.builder((String)"ContactFilter").add("Channel", this.hasChannel() ? this.channel() : null).add("ContactArn", (Object)this.contactArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channel()));
            }
            case "contactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channel", CHANNEL_FIELD);
        map.put("contactArn", CONTACT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFilter, T> g) {
        return obj -> g.apply((ContactFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> channel = DefaultSdkAutoConstructList.getInstance();
        private String contactArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFilter model) {
            this.channel(model.channel);
            this.contactArn(model.contactArn);
        }

        public final Collection<String> getChannel() {
            if (this.channel instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channel;
        }

        public final void setChannel(Collection<String> channel) {
            this.channel = ContactFilterChannelListCopier.copy(channel);
        }

        @Override
        public final Builder channel(Collection<String> channel) {
            this.channel = ContactFilterChannelListCopier.copy(channel);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channel(String ... channel) {
            this.channel(Arrays.asList(channel));
            return this;
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public ContactFilter build() {
            return new ContactFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactFilter> {
        public Builder channel(Collection<String> var1);

        public Builder channel(String ... var1);

        public Builder contactArn(String var1);
    }
}

