/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsRequest;
import software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsResponse;
import software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsResponseItem;

public class SearchAllRelatedItemsIterable
implements SdkIterable<SearchAllRelatedItemsResponse> {
    private final ConnectCasesClient client;
    private final SearchAllRelatedItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchAllRelatedItemsIterable(ConnectCasesClient client, SearchAllRelatedItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchAllRelatedItemsResponseFetcher();
    }

    public Iterator<SearchAllRelatedItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchAllRelatedItemsResponseItem> relatedItems() {
        Function<SearchAllRelatedItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.relatedItems() != null) {
                return response.relatedItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchAllRelatedItemsResponseFetcher
    implements SyncPageFetcher<SearchAllRelatedItemsResponse> {
        private SearchAllRelatedItemsResponseFetcher() {
        }

        public boolean hasNextPage(SearchAllRelatedItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchAllRelatedItemsResponse nextPage(SearchAllRelatedItemsResponse previousPage) {
            if (previousPage == null) {
                return SearchAllRelatedItemsIterable.this.client.searchAllRelatedItems(SearchAllRelatedItemsIterable.this.firstRequest);
            }
            return SearchAllRelatedItemsIterable.this.client.searchAllRelatedItems((SearchAllRelatedItemsRequest)((Object)SearchAllRelatedItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

