/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcases.model.RuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaseRuleSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaseRuleSummary> {
    private static final SdkField<String> CASE_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseRuleId").getter(CaseRuleSummary.getter(CaseRuleSummary::caseRuleId)).setter(CaseRuleSummary.setter(Builder::caseRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CaseRuleSummary.getter(CaseRuleSummary::name)).setter(CaseRuleSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CASE_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseRuleArn").getter(CaseRuleSummary.getter(CaseRuleSummary::caseRuleArn)).setter(CaseRuleSummary.setter(Builder::caseRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleArn").build()}).build();
    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleType").getter(CaseRuleSummary.getter(CaseRuleSummary::ruleTypeAsString)).setter(CaseRuleSummary.setter(Builder::ruleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CaseRuleSummary.getter(CaseRuleSummary::description)).setter(CaseRuleSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_RULE_ID_FIELD, NAME_FIELD, CASE_RULE_ARN_FIELD, RULE_TYPE_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CaseRuleSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String caseRuleId;
    private final String name;
    private final String caseRuleArn;
    private final String ruleType;
    private final String description;

    private CaseRuleSummary(BuilderImpl builder) {
        this.caseRuleId = builder.caseRuleId;
        this.name = builder.name;
        this.caseRuleArn = builder.caseRuleArn;
        this.ruleType = builder.ruleType;
        this.description = builder.description;
    }

    public final String caseRuleId() {
        return this.caseRuleId;
    }

    public final String name() {
        return this.name;
    }

    public final String caseRuleArn() {
        return this.caseRuleArn;
    }

    public final RuleType ruleType() {
        return RuleType.fromValue(this.ruleType);
    }

    public final String ruleTypeAsString() {
        return this.ruleType;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caseRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseRuleSummary)) {
            return false;
        }
        CaseRuleSummary other = (CaseRuleSummary)obj;
        return Objects.equals(this.caseRuleId(), other.caseRuleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.caseRuleArn(), other.caseRuleArn()) && Objects.equals(this.ruleTypeAsString(), other.ruleTypeAsString()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"CaseRuleSummary").add("CaseRuleId", (Object)this.caseRuleId()).add("Name", (Object)this.name()).add("CaseRuleArn", (Object)this.caseRuleArn()).add("RuleType", (Object)this.ruleTypeAsString()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseRuleId": {
                return Optional.ofNullable(clazz.cast(this.caseRuleId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "caseRuleArn": {
                return Optional.ofNullable(clazz.cast(this.caseRuleArn()));
            }
            case "ruleType": {
                return Optional.ofNullable(clazz.cast(this.ruleTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("caseRuleId", CASE_RULE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("caseRuleArn", CASE_RULE_ARN_FIELD);
        map.put("ruleType", RULE_TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseRuleSummary, T> g) {
        return obj -> g.apply((CaseRuleSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String caseRuleId;
        private String name;
        private String caseRuleArn;
        private String ruleType;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseRuleSummary model) {
            this.caseRuleId(model.caseRuleId);
            this.name(model.name);
            this.caseRuleArn(model.caseRuleArn);
            this.ruleType(model.ruleType);
            this.description(model.description);
        }

        public final String getCaseRuleId() {
            return this.caseRuleId;
        }

        public final void setCaseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
        }

        @Override
        public final Builder caseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCaseRuleArn() {
            return this.caseRuleArn;
        }

        public final void setCaseRuleArn(String caseRuleArn) {
            this.caseRuleArn = caseRuleArn;
        }

        @Override
        public final Builder caseRuleArn(String caseRuleArn) {
            this.caseRuleArn = caseRuleArn;
            return this;
        }

        public final String getRuleType() {
            return this.ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public CaseRuleSummary build() {
            return new CaseRuleSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaseRuleSummary> {
        public Builder caseRuleId(String var1);

        public Builder name(String var1);

        public Builder caseRuleArn(String var1);

        public Builder ruleType(String var1);

        public Builder ruleType(RuleType var1);

        public Builder description(String var1);
    }
}

