/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.ParentChildFieldOptionsMapping;
import software.amazon.awssdk.services.connectcases.model.ParentChildFieldOptionsMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldOptionsCaseRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldOptionsCaseRule> {
    private static final SdkField<String> PARENT_FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentFieldId").getter(FieldOptionsCaseRule.getter(FieldOptionsCaseRule::parentFieldId)).setter(FieldOptionsCaseRule.setter(Builder::parentFieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentFieldId").build()}).build();
    private static final SdkField<String> CHILD_FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("childFieldId").getter(FieldOptionsCaseRule.getter(FieldOptionsCaseRule::childFieldId)).setter(FieldOptionsCaseRule.setter(Builder::childFieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childFieldId").build()}).build();
    private static final SdkField<List<ParentChildFieldOptionsMapping>> PARENT_CHILD_FIELD_OPTIONS_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parentChildFieldOptionsMappings").getter(FieldOptionsCaseRule.getter(FieldOptionsCaseRule::parentChildFieldOptionsMappings)).setter(FieldOptionsCaseRule.setter(Builder::parentChildFieldOptionsMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentChildFieldOptionsMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParentChildFieldOptionsMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_FIELD_ID_FIELD, CHILD_FIELD_ID_FIELD, PARENT_CHILD_FIELD_OPTIONS_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FieldOptionsCaseRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String parentFieldId;
    private final String childFieldId;
    private final List<ParentChildFieldOptionsMapping> parentChildFieldOptionsMappings;

    private FieldOptionsCaseRule(BuilderImpl builder) {
        this.parentFieldId = builder.parentFieldId;
        this.childFieldId = builder.childFieldId;
        this.parentChildFieldOptionsMappings = builder.parentChildFieldOptionsMappings;
    }

    public final String parentFieldId() {
        return this.parentFieldId;
    }

    public final String childFieldId() {
        return this.childFieldId;
    }

    public final boolean hasParentChildFieldOptionsMappings() {
        return this.parentChildFieldOptionsMappings != null && !(this.parentChildFieldOptionsMappings instanceof SdkAutoConstructList);
    }

    public final List<ParentChildFieldOptionsMapping> parentChildFieldOptionsMappings() {
        return this.parentChildFieldOptionsMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentFieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.childFieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParentChildFieldOptionsMappings() ? this.parentChildFieldOptionsMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldOptionsCaseRule)) {
            return false;
        }
        FieldOptionsCaseRule other = (FieldOptionsCaseRule)obj;
        return Objects.equals(this.parentFieldId(), other.parentFieldId()) && Objects.equals(this.childFieldId(), other.childFieldId()) && this.hasParentChildFieldOptionsMappings() == other.hasParentChildFieldOptionsMappings() && Objects.equals(this.parentChildFieldOptionsMappings(), other.parentChildFieldOptionsMappings());
    }

    public final String toString() {
        return ToString.builder((String)"FieldOptionsCaseRule").add("ParentFieldId", (Object)this.parentFieldId()).add("ChildFieldId", (Object)this.childFieldId()).add("ParentChildFieldOptionsMappings", this.hasParentChildFieldOptionsMappings() ? this.parentChildFieldOptionsMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parentFieldId": {
                return Optional.ofNullable(clazz.cast(this.parentFieldId()));
            }
            case "childFieldId": {
                return Optional.ofNullable(clazz.cast(this.childFieldId()));
            }
            case "parentChildFieldOptionsMappings": {
                return Optional.ofNullable(clazz.cast(this.parentChildFieldOptionsMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("parentFieldId", PARENT_FIELD_ID_FIELD);
        map.put("childFieldId", CHILD_FIELD_ID_FIELD);
        map.put("parentChildFieldOptionsMappings", PARENT_CHILD_FIELD_OPTIONS_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldOptionsCaseRule, T> g) {
        return obj -> g.apply((FieldOptionsCaseRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parentFieldId;
        private String childFieldId;
        private List<ParentChildFieldOptionsMapping> parentChildFieldOptionsMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldOptionsCaseRule model) {
            this.parentFieldId(model.parentFieldId);
            this.childFieldId(model.childFieldId);
            this.parentChildFieldOptionsMappings(model.parentChildFieldOptionsMappings);
        }

        public final String getParentFieldId() {
            return this.parentFieldId;
        }

        public final void setParentFieldId(String parentFieldId) {
            this.parentFieldId = parentFieldId;
        }

        @Override
        public final Builder parentFieldId(String parentFieldId) {
            this.parentFieldId = parentFieldId;
            return this;
        }

        public final String getChildFieldId() {
            return this.childFieldId;
        }

        public final void setChildFieldId(String childFieldId) {
            this.childFieldId = childFieldId;
        }

        @Override
        public final Builder childFieldId(String childFieldId) {
            this.childFieldId = childFieldId;
            return this;
        }

        public final List<ParentChildFieldOptionsMapping.Builder> getParentChildFieldOptionsMappings() {
            List<ParentChildFieldOptionsMapping.Builder> result = ParentChildFieldOptionsMappingListCopier.copyToBuilder(this.parentChildFieldOptionsMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParentChildFieldOptionsMappings(Collection<ParentChildFieldOptionsMapping.BuilderImpl> parentChildFieldOptionsMappings) {
            this.parentChildFieldOptionsMappings = ParentChildFieldOptionsMappingListCopier.copyFromBuilder(parentChildFieldOptionsMappings);
        }

        @Override
        public final Builder parentChildFieldOptionsMappings(Collection<ParentChildFieldOptionsMapping> parentChildFieldOptionsMappings) {
            this.parentChildFieldOptionsMappings = ParentChildFieldOptionsMappingListCopier.copy(parentChildFieldOptionsMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentChildFieldOptionsMappings(ParentChildFieldOptionsMapping ... parentChildFieldOptionsMappings) {
            this.parentChildFieldOptionsMappings(Arrays.asList(parentChildFieldOptionsMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentChildFieldOptionsMappings(Consumer<ParentChildFieldOptionsMapping.Builder> ... parentChildFieldOptionsMappings) {
            this.parentChildFieldOptionsMappings(Stream.of(parentChildFieldOptionsMappings).map(c -> (ParentChildFieldOptionsMapping)((ParentChildFieldOptionsMapping.Builder)ParentChildFieldOptionsMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FieldOptionsCaseRule build() {
            return new FieldOptionsCaseRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldOptionsCaseRule> {
        public Builder parentFieldId(String var1);

        public Builder childFieldId(String var1);

        public Builder parentChildFieldOptionsMappings(Collection<ParentChildFieldOptionsMapping> var1);

        public Builder parentChildFieldOptionsMappings(ParentChildFieldOptionsMapping ... var1);

        public Builder parentChildFieldOptionsMappings(Consumer<ParentChildFieldOptionsMapping.Builder> ... var1);
    }
}

