/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.ParentChildFieldOptionsMappingChildFieldOptionValuesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParentChildFieldOptionsMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParentChildFieldOptionsMapping> {
    private static final SdkField<String> PARENT_FIELD_OPTION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentFieldOptionValue").getter(ParentChildFieldOptionsMapping.getter(ParentChildFieldOptionsMapping::parentFieldOptionValue)).setter(ParentChildFieldOptionsMapping.setter(Builder::parentFieldOptionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentFieldOptionValue").build()}).build();
    private static final SdkField<List<String>> CHILD_FIELD_OPTION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("childFieldOptionValues").getter(ParentChildFieldOptionsMapping.getter(ParentChildFieldOptionsMapping::childFieldOptionValues)).setter(ParentChildFieldOptionsMapping.setter(Builder::childFieldOptionValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childFieldOptionValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_FIELD_OPTION_VALUE_FIELD, CHILD_FIELD_OPTION_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParentChildFieldOptionsMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String parentFieldOptionValue;
    private final List<String> childFieldOptionValues;

    private ParentChildFieldOptionsMapping(BuilderImpl builder) {
        this.parentFieldOptionValue = builder.parentFieldOptionValue;
        this.childFieldOptionValues = builder.childFieldOptionValues;
    }

    public final String parentFieldOptionValue() {
        return this.parentFieldOptionValue;
    }

    public final boolean hasChildFieldOptionValues() {
        return this.childFieldOptionValues != null && !(this.childFieldOptionValues instanceof SdkAutoConstructList);
    }

    public final List<String> childFieldOptionValues() {
        return this.childFieldOptionValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentFieldOptionValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildFieldOptionValues() ? this.childFieldOptionValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParentChildFieldOptionsMapping)) {
            return false;
        }
        ParentChildFieldOptionsMapping other = (ParentChildFieldOptionsMapping)obj;
        return Objects.equals(this.parentFieldOptionValue(), other.parentFieldOptionValue()) && this.hasChildFieldOptionValues() == other.hasChildFieldOptionValues() && Objects.equals(this.childFieldOptionValues(), other.childFieldOptionValues());
    }

    public final String toString() {
        return ToString.builder((String)"ParentChildFieldOptionsMapping").add("ParentFieldOptionValue", (Object)this.parentFieldOptionValue()).add("ChildFieldOptionValues", this.hasChildFieldOptionValues() ? this.childFieldOptionValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parentFieldOptionValue": {
                return Optional.ofNullable(clazz.cast(this.parentFieldOptionValue()));
            }
            case "childFieldOptionValues": {
                return Optional.ofNullable(clazz.cast(this.childFieldOptionValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("parentFieldOptionValue", PARENT_FIELD_OPTION_VALUE_FIELD);
        map.put("childFieldOptionValues", CHILD_FIELD_OPTION_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParentChildFieldOptionsMapping, T> g) {
        return obj -> g.apply((ParentChildFieldOptionsMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parentFieldOptionValue;
        private List<String> childFieldOptionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParentChildFieldOptionsMapping model) {
            this.parentFieldOptionValue(model.parentFieldOptionValue);
            this.childFieldOptionValues(model.childFieldOptionValues);
        }

        public final String getParentFieldOptionValue() {
            return this.parentFieldOptionValue;
        }

        public final void setParentFieldOptionValue(String parentFieldOptionValue) {
            this.parentFieldOptionValue = parentFieldOptionValue;
        }

        @Override
        public final Builder parentFieldOptionValue(String parentFieldOptionValue) {
            this.parentFieldOptionValue = parentFieldOptionValue;
            return this;
        }

        public final Collection<String> getChildFieldOptionValues() {
            if (this.childFieldOptionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.childFieldOptionValues;
        }

        public final void setChildFieldOptionValues(Collection<String> childFieldOptionValues) {
            this.childFieldOptionValues = ParentChildFieldOptionsMappingChildFieldOptionValuesListCopier.copy(childFieldOptionValues);
        }

        @Override
        public final Builder childFieldOptionValues(Collection<String> childFieldOptionValues) {
            this.childFieldOptionValues = ParentChildFieldOptionsMappingChildFieldOptionValuesListCopier.copy(childFieldOptionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childFieldOptionValues(String ... childFieldOptionValues) {
            this.childFieldOptionValues(Arrays.asList(childFieldOptionValues));
            return this;
        }

        public ParentChildFieldOptionsMapping build() {
            return new ParentChildFieldOptionsMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParentChildFieldOptionsMapping> {
        public Builder parentFieldOptionValue(String var1);

        public Builder childFieldOptionValues(Collection<String> var1);

        public Builder childFieldOptionValues(String ... var1);
    }
}

