/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesRequest;
import software.amazon.awssdk.services.connectcases.model.RelatedItemTypeFilter;
import software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsRequestFiltersListCopier;
import software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsRequestSortsListCopier;
import software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsSort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAllRelatedItemsRequest
extends ConnectCasesRequest
implements ToCopyableBuilder<Builder, SearchAllRelatedItemsRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(SearchAllRelatedItemsRequest.getter(SearchAllRelatedItemsRequest::domainId)).setter(SearchAllRelatedItemsRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(SearchAllRelatedItemsRequest.getter(SearchAllRelatedItemsRequest::maxResults)).setter(SearchAllRelatedItemsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchAllRelatedItemsRequest.getter(SearchAllRelatedItemsRequest::nextToken)).setter(SearchAllRelatedItemsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<RelatedItemTypeFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(SearchAllRelatedItemsRequest.getter(SearchAllRelatedItemsRequest::filters)).setter(SearchAllRelatedItemsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedItemTypeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SearchAllRelatedItemsSort>> SORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sorts").getter(SearchAllRelatedItemsRequest.getter(SearchAllRelatedItemsRequest::sorts)).setter(SearchAllRelatedItemsRequest.setter(Builder::sorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sorts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchAllRelatedItemsSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD, SORTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchAllRelatedItemsRequest.memberNameToFieldInitializer();
    private final String domainId;
    private final Integer maxResults;
    private final String nextToken;
    private final List<RelatedItemTypeFilter> filters;
    private final List<SearchAllRelatedItemsSort> sorts;

    private SearchAllRelatedItemsRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
        this.sorts = builder.sorts;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<RelatedItemTypeFilter> filters() {
        return this.filters;
    }

    public final boolean hasSorts() {
        return this.sorts != null && !(this.sorts instanceof SdkAutoConstructList);
    }

    public final List<SearchAllRelatedItemsSort> sorts() {
        return this.sorts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSorts() ? this.sorts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAllRelatedItemsRequest)) {
            return false;
        }
        SearchAllRelatedItemsRequest other = (SearchAllRelatedItemsRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasSorts() == other.hasSorts() && Objects.equals(this.sorts(), other.sorts());
    }

    public final String toString() {
        return ToString.builder((String)"SearchAllRelatedItemsRequest").add("DomainId", (Object)this.domainId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Filters", this.hasFilters() ? this.filters() : null).add("Sorts", this.hasSorts() ? this.sorts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "sorts": {
                return Optional.ofNullable(clazz.cast(this.sorts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("sorts", SORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchAllRelatedItemsRequest, T> g) {
        return obj -> g.apply((SearchAllRelatedItemsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private Integer maxResults;
        private String nextToken;
        private List<RelatedItemTypeFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<SearchAllRelatedItemsSort> sorts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAllRelatedItemsRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.filters(model.filters);
            this.sorts(model.sorts);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RelatedItemTypeFilter.Builder> getFilters() {
            List<RelatedItemTypeFilter.Builder> result = SearchAllRelatedItemsRequestFiltersListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<RelatedItemTypeFilter.BuilderImpl> filters) {
            this.filters = SearchAllRelatedItemsRequestFiltersListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<RelatedItemTypeFilter> filters) {
            this.filters = SearchAllRelatedItemsRequestFiltersListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(RelatedItemTypeFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<RelatedItemTypeFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (RelatedItemTypeFilter)((RelatedItemTypeFilter.Builder)RelatedItemTypeFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SearchAllRelatedItemsSort.Builder> getSorts() {
            List<SearchAllRelatedItemsSort.Builder> result = SearchAllRelatedItemsRequestSortsListCopier.copyToBuilder(this.sorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSorts(Collection<SearchAllRelatedItemsSort.BuilderImpl> sorts) {
            this.sorts = SearchAllRelatedItemsRequestSortsListCopier.copyFromBuilder(sorts);
        }

        @Override
        public final Builder sorts(Collection<SearchAllRelatedItemsSort> sorts) {
            this.sorts = SearchAllRelatedItemsRequestSortsListCopier.copy(sorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sorts(SearchAllRelatedItemsSort ... sorts) {
            this.sorts(Arrays.asList(sorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sorts(Consumer<SearchAllRelatedItemsSort.Builder> ... sorts) {
            this.sorts(Stream.of(sorts).map(c -> (SearchAllRelatedItemsSort)((SearchAllRelatedItemsSort.Builder)SearchAllRelatedItemsSort.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchAllRelatedItemsRequest build() {
            return new SearchAllRelatedItemsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectCasesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAllRelatedItemsRequest> {
        public Builder domainId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder filters(Collection<RelatedItemTypeFilter> var1);

        public Builder filters(RelatedItemTypeFilter ... var1);

        public Builder filters(Consumer<RelatedItemTypeFilter.Builder> ... var1);

        public Builder sorts(Collection<SearchAllRelatedItemsSort> var1);

        public Builder sorts(SearchAllRelatedItemsSort ... var1);

        public Builder sorts(Consumer<SearchAllRelatedItemsSort.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

