/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsRequest;
import software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsResponse;
import software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsResponseItem;

public class SearchAllRelatedItemsPublisher
implements SdkPublisher<SearchAllRelatedItemsResponse> {
    private final ConnectCasesAsyncClient client;
    private final SearchAllRelatedItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchAllRelatedItemsPublisher(ConnectCasesAsyncClient client, SearchAllRelatedItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchAllRelatedItemsPublisher(ConnectCasesAsyncClient client, SearchAllRelatedItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchAllRelatedItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchAllRelatedItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SearchAllRelatedItemsResponseItem> relatedItems() {
        Function<SearchAllRelatedItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.relatedItems() != null) {
                return response.relatedItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchAllRelatedItemsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchAllRelatedItemsResponseFetcher
    implements AsyncPageFetcher<SearchAllRelatedItemsResponse> {
        private SearchAllRelatedItemsResponseFetcher() {
        }

        public boolean hasNextPage(SearchAllRelatedItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchAllRelatedItemsResponse> nextPage(SearchAllRelatedItemsResponse previousPage) {
            if (previousPage == null) {
                return SearchAllRelatedItemsPublisher.this.client.searchAllRelatedItems(SearchAllRelatedItemsPublisher.this.firstRequest);
            }
            return SearchAllRelatedItemsPublisher.this.client.searchAllRelatedItems((SearchAllRelatedItemsRequest)((Object)SearchAllRelatedItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

