/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectparticipant.model.Receipt;
import software.amazon.awssdk.services.connectparticipant.model.ReceiptsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageMetadata> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(MessageMetadata.getter(MessageMetadata::messageId)).setter(MessageMetadata.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<List<Receipt>> RECEIPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Receipts").getter(MessageMetadata.getter(MessageMetadata::receipts)).setter(MessageMetadata.setter(Builder::receipts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Receipts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Receipt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, RECEIPTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final List<Receipt> receipts;

    private MessageMetadata(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.receipts = builder.receipts;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final boolean hasReceipts() {
        return this.receipts != null && !(this.receipts instanceof SdkAutoConstructList);
    }

    public final List<Receipt> receipts() {
        return this.receipts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReceipts() ? this.receipts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageMetadata)) {
            return false;
        }
        MessageMetadata other = (MessageMetadata)obj;
        return Objects.equals(this.messageId(), other.messageId()) && this.hasReceipts() == other.hasReceipts() && Objects.equals(this.receipts(), other.receipts());
    }

    public final String toString() {
        return ToString.builder((String)"MessageMetadata").add("MessageId", (Object)this.messageId()).add("Receipts", this.hasReceipts() ? this.receipts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "Receipts": {
                return Optional.ofNullable(clazz.cast(this.receipts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MessageId", MESSAGE_ID_FIELD);
        map.put("Receipts", RECEIPTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageMetadata, T> g) {
        return obj -> g.apply((MessageMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private List<Receipt> receipts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageMetadata model) {
            this.messageId(model.messageId);
            this.receipts(model.receipts);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final List<Receipt.Builder> getReceipts() {
            List<Receipt.Builder> result = ReceiptsCopier.copyToBuilder(this.receipts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReceipts(Collection<Receipt.BuilderImpl> receipts) {
            this.receipts = ReceiptsCopier.copyFromBuilder(receipts);
        }

        @Override
        public final Builder receipts(Collection<Receipt> receipts) {
            this.receipts = ReceiptsCopier.copy(receipts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receipts(Receipt ... receipts) {
            this.receipts(Arrays.asList(receipts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receipts(Consumer<Receipt.Builder> ... receipts) {
            this.receipts(Stream.of(receipts).map(c -> (Receipt)((Receipt.Builder)Receipt.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MessageMetadata build() {
            return new MessageMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageMetadata> {
        public Builder messageId(String var1);

        public Builder receipts(Collection<Receipt> var1);

        public Builder receipts(Receipt ... var1);

        public Builder receipts(Consumer<Receipt.Builder> ... var1);
    }
}

