/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectparticipant.ConnectParticipantClient;
import software.amazon.awssdk.services.connectparticipant.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectparticipant.model.GetTranscriptRequest;
import software.amazon.awssdk.services.connectparticipant.model.GetTranscriptResponse;

public class GetTranscriptIterable
implements SdkIterable<GetTranscriptResponse> {
    private final ConnectParticipantClient client;
    private final GetTranscriptRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTranscriptIterable(ConnectParticipantClient client, GetTranscriptRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetTranscriptResponseFetcher();
    }

    public Iterator<GetTranscriptResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetTranscriptResponseFetcher
    implements SyncPageFetcher<GetTranscriptResponse> {
        private GetTranscriptResponseFetcher() {
        }

        public boolean hasNextPage(GetTranscriptResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTranscriptResponse nextPage(GetTranscriptResponse previousPage) {
            if (previousPage == null) {
                return GetTranscriptIterable.this.client.getTranscript(GetTranscriptIterable.this.firstRequest);
            }
            return GetTranscriptIterable.this.client.getTranscript((GetTranscriptRequest)((Object)GetTranscriptIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

