/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controlcatalog.ControlCatalogClient;
import software.amazon.awssdk.services.controlcatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.controlcatalog.model.ListObjectivesRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListObjectivesResponse;
import software.amazon.awssdk.services.controlcatalog.model.ObjectiveSummary;

public class ListObjectivesIterable
implements SdkIterable<ListObjectivesResponse> {
    private final ControlCatalogClient client;
    private final ListObjectivesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObjectivesIterable(ControlCatalogClient client, ListObjectivesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListObjectivesResponseFetcher();
    }

    public Iterator<ListObjectivesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ObjectiveSummary> objectives() {
        Function<ListObjectivesResponse, Iterator> getIterator = response -> {
            if (response != null && response.objectives() != null) {
                return response.objectives().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListObjectivesResponseFetcher
    implements SyncPageFetcher<ListObjectivesResponse> {
        private ListObjectivesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectivesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListObjectivesResponse nextPage(ListObjectivesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectivesIterable.this.client.listObjectives(ListObjectivesIterable.this.firstRequest);
            }
            return ListObjectivesIterable.this.client.listObjectives((ListObjectivesRequest)((Object)ListObjectivesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

