/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.ControlTowerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLandingZoneRequest
extends ControlTowerRequest
implements ToCopyableBuilder<Builder, GetLandingZoneRequest> {
    private static final SdkField<String> LANDING_ZONE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("landingZoneIdentifier").getter(GetLandingZoneRequest.getter(GetLandingZoneRequest::landingZoneIdentifier)).setter(GetLandingZoneRequest.setter(Builder::landingZoneIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("landingZoneIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANDING_ZONE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLandingZoneRequest.memberNameToFieldInitializer();
    private final String landingZoneIdentifier;

    private GetLandingZoneRequest(BuilderImpl builder) {
        super(builder);
        this.landingZoneIdentifier = builder.landingZoneIdentifier;
    }

    public final String landingZoneIdentifier() {
        return this.landingZoneIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.landingZoneIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLandingZoneRequest)) {
            return false;
        }
        GetLandingZoneRequest other = (GetLandingZoneRequest)((Object)obj);
        return Objects.equals(this.landingZoneIdentifier(), other.landingZoneIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetLandingZoneRequest").add("LandingZoneIdentifier", (Object)this.landingZoneIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "landingZoneIdentifier": {
                return Optional.ofNullable(clazz.cast(this.landingZoneIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("landingZoneIdentifier", LANDING_ZONE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLandingZoneRequest, T> g) {
        return obj -> g.apply((GetLandingZoneRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerRequest.BuilderImpl
    implements Builder {
        private String landingZoneIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLandingZoneRequest model) {
            super(model);
            this.landingZoneIdentifier(model.landingZoneIdentifier);
        }

        public final String getLandingZoneIdentifier() {
            return this.landingZoneIdentifier;
        }

        public final void setLandingZoneIdentifier(String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
        }

        @Override
        public final Builder landingZoneIdentifier(String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLandingZoneRequest build() {
            return new GetLandingZoneRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ControlTowerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLandingZoneRequest> {
        public Builder landingZoneIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

