/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.ControlTowerResponse;
import software.amazon.awssdk.services.controltower.model.LandingZoneSummary;
import software.amazon.awssdk.services.controltower.model.ListLandingZonesOutputLandingZonesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLandingZonesResponse
extends ControlTowerResponse
implements ToCopyableBuilder<Builder, ListLandingZonesResponse> {
    private static final SdkField<List<LandingZoneSummary>> LANDING_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("landingZones").getter(ListLandingZonesResponse.getter(ListLandingZonesResponse::landingZones)).setter(ListLandingZonesResponse.setter(Builder::landingZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("landingZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LandingZoneSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLandingZonesResponse.getter(ListLandingZonesResponse::nextToken)).setter(ListLandingZonesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANDING_ZONES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLandingZonesResponse.memberNameToFieldInitializer();
    private final List<LandingZoneSummary> landingZones;
    private final String nextToken;

    private ListLandingZonesResponse(BuilderImpl builder) {
        super(builder);
        this.landingZones = builder.landingZones;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLandingZones() {
        return this.landingZones != null && !(this.landingZones instanceof SdkAutoConstructList);
    }

    public final List<LandingZoneSummary> landingZones() {
        return this.landingZones;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLandingZones() ? this.landingZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLandingZonesResponse)) {
            return false;
        }
        ListLandingZonesResponse other = (ListLandingZonesResponse)((Object)obj);
        return this.hasLandingZones() == other.hasLandingZones() && Objects.equals(this.landingZones(), other.landingZones()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLandingZonesResponse").add("LandingZones", this.hasLandingZones() ? this.landingZones() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "landingZones": {
                return Optional.ofNullable(clazz.cast(this.landingZones()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("landingZones", LANDING_ZONES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLandingZonesResponse, T> g) {
        return obj -> g.apply((ListLandingZonesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerResponse.BuilderImpl
    implements Builder {
        private List<LandingZoneSummary> landingZones = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLandingZonesResponse model) {
            super(model);
            this.landingZones(model.landingZones);
            this.nextToken(model.nextToken);
        }

        public final List<LandingZoneSummary.Builder> getLandingZones() {
            List<LandingZoneSummary.Builder> result = ListLandingZonesOutputLandingZonesListCopier.copyToBuilder(this.landingZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLandingZones(Collection<LandingZoneSummary.BuilderImpl> landingZones) {
            this.landingZones = ListLandingZonesOutputLandingZonesListCopier.copyFromBuilder(landingZones);
        }

        @Override
        public final Builder landingZones(Collection<LandingZoneSummary> landingZones) {
            this.landingZones = ListLandingZonesOutputLandingZonesListCopier.copy(landingZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landingZones(LandingZoneSummary ... landingZones) {
            this.landingZones(Arrays.asList(landingZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landingZones(Consumer<LandingZoneSummary.Builder> ... landingZones) {
            this.landingZones(Stream.of(landingZones).map(c -> (LandingZoneSummary)((LandingZoneSummary.Builder)LandingZoneSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLandingZonesResponse build() {
            return new ListLandingZonesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ControlTowerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLandingZonesResponse> {
        public Builder landingZones(Collection<LandingZoneSummary> var1);

        public Builder landingZones(LandingZoneSummary ... var1);

        public Builder landingZones(Consumer<LandingZoneSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

