/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.ControlIdentifiersCopier;
import software.amazon.awssdk.services.controltower.model.DriftStatus;
import software.amazon.awssdk.services.controltower.model.DriftStatusesCopier;
import software.amazon.awssdk.services.controltower.model.EnablementStatus;
import software.amazon.awssdk.services.controltower.model.EnablementStatusesCopier;
import software.amazon.awssdk.services.controltower.model.ParentIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnabledControlFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnabledControlFilter> {
    private static final SdkField<List<String>> CONTROL_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlIdentifiers").getter(EnabledControlFilter.getter(EnabledControlFilter::controlIdentifiers)).setter(EnabledControlFilter.setter(Builder::controlIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statuses").getter(EnabledControlFilter.getter(EnabledControlFilter::statusesAsStrings)).setter(EnabledControlFilter.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DRIFT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("driftStatuses").getter(EnabledControlFilter.getter(EnabledControlFilter::driftStatusesAsStrings)).setter(EnabledControlFilter.setter(Builder::driftStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PARENT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parentIdentifiers").getter(EnabledControlFilter.getter(EnabledControlFilter::parentIdentifiers)).setter(EnabledControlFilter.setter(Builder::parentIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INHERITANCE_DRIFT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inheritanceDriftStatuses").getter(EnabledControlFilter.getter(EnabledControlFilter::inheritanceDriftStatusesAsStrings)).setter(EnabledControlFilter.setter(Builder::inheritanceDriftStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inheritanceDriftStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_DRIFT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceDriftStatuses").getter(EnabledControlFilter.getter(EnabledControlFilter::resourceDriftStatusesAsStrings)).setter(EnabledControlFilter.setter(Builder::resourceDriftStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDriftStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_IDENTIFIERS_FIELD, STATUSES_FIELD, DRIFT_STATUSES_FIELD, PARENT_IDENTIFIERS_FIELD, INHERITANCE_DRIFT_STATUSES_FIELD, RESOURCE_DRIFT_STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnabledControlFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> controlIdentifiers;
    private final List<String> statuses;
    private final List<String> driftStatuses;
    private final List<String> parentIdentifiers;
    private final List<String> inheritanceDriftStatuses;
    private final List<String> resourceDriftStatuses;

    private EnabledControlFilter(BuilderImpl builder) {
        this.controlIdentifiers = builder.controlIdentifiers;
        this.statuses = builder.statuses;
        this.driftStatuses = builder.driftStatuses;
        this.parentIdentifiers = builder.parentIdentifiers;
        this.inheritanceDriftStatuses = builder.inheritanceDriftStatuses;
        this.resourceDriftStatuses = builder.resourceDriftStatuses;
    }

    public final boolean hasControlIdentifiers() {
        return this.controlIdentifiers != null && !(this.controlIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> controlIdentifiers() {
        return this.controlIdentifiers;
    }

    public final List<EnablementStatus> statuses() {
        return EnablementStatusesCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public final List<DriftStatus> driftStatuses() {
        return DriftStatusesCopier.copyStringToEnum(this.driftStatuses);
    }

    public final boolean hasDriftStatuses() {
        return this.driftStatuses != null && !(this.driftStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> driftStatusesAsStrings() {
        return this.driftStatuses;
    }

    public final boolean hasParentIdentifiers() {
        return this.parentIdentifiers != null && !(this.parentIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> parentIdentifiers() {
        return this.parentIdentifiers;
    }

    public final List<DriftStatus> inheritanceDriftStatuses() {
        return DriftStatusesCopier.copyStringToEnum(this.inheritanceDriftStatuses);
    }

    public final boolean hasInheritanceDriftStatuses() {
        return this.inheritanceDriftStatuses != null && !(this.inheritanceDriftStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> inheritanceDriftStatusesAsStrings() {
        return this.inheritanceDriftStatuses;
    }

    public final List<DriftStatus> resourceDriftStatuses() {
        return DriftStatusesCopier.copyStringToEnum(this.resourceDriftStatuses);
    }

    public final boolean hasResourceDriftStatuses() {
        return this.resourceDriftStatuses != null && !(this.resourceDriftStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> resourceDriftStatusesAsStrings() {
        return this.resourceDriftStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlIdentifiers() ? this.controlIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDriftStatuses() ? this.driftStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParentIdentifiers() ? this.parentIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInheritanceDriftStatuses() ? this.inheritanceDriftStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceDriftStatuses() ? this.resourceDriftStatusesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledControlFilter)) {
            return false;
        }
        EnabledControlFilter other = (EnabledControlFilter)obj;
        return this.hasControlIdentifiers() == other.hasControlIdentifiers() && Objects.equals(this.controlIdentifiers(), other.controlIdentifiers()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && this.hasDriftStatuses() == other.hasDriftStatuses() && Objects.equals(this.driftStatusesAsStrings(), other.driftStatusesAsStrings()) && this.hasParentIdentifiers() == other.hasParentIdentifiers() && Objects.equals(this.parentIdentifiers(), other.parentIdentifiers()) && this.hasInheritanceDriftStatuses() == other.hasInheritanceDriftStatuses() && Objects.equals(this.inheritanceDriftStatusesAsStrings(), other.inheritanceDriftStatusesAsStrings()) && this.hasResourceDriftStatuses() == other.hasResourceDriftStatuses() && Objects.equals(this.resourceDriftStatusesAsStrings(), other.resourceDriftStatusesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EnabledControlFilter").add("ControlIdentifiers", this.hasControlIdentifiers() ? this.controlIdentifiers() : null).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("DriftStatuses", this.hasDriftStatuses() ? this.driftStatusesAsStrings() : null).add("ParentIdentifiers", this.hasParentIdentifiers() ? this.parentIdentifiers() : null).add("InheritanceDriftStatuses", this.hasInheritanceDriftStatuses() ? this.inheritanceDriftStatusesAsStrings() : null).add("ResourceDriftStatuses", this.hasResourceDriftStatuses() ? this.resourceDriftStatusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "controlIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.controlIdentifiers()));
            }
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "driftStatuses": {
                return Optional.ofNullable(clazz.cast(this.driftStatusesAsStrings()));
            }
            case "parentIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.parentIdentifiers()));
            }
            case "inheritanceDriftStatuses": {
                return Optional.ofNullable(clazz.cast(this.inheritanceDriftStatusesAsStrings()));
            }
            case "resourceDriftStatuses": {
                return Optional.ofNullable(clazz.cast(this.resourceDriftStatusesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("controlIdentifiers", CONTROL_IDENTIFIERS_FIELD);
        map.put("statuses", STATUSES_FIELD);
        map.put("driftStatuses", DRIFT_STATUSES_FIELD);
        map.put("parentIdentifiers", PARENT_IDENTIFIERS_FIELD);
        map.put("inheritanceDriftStatuses", INHERITANCE_DRIFT_STATUSES_FIELD);
        map.put("resourceDriftStatuses", RESOURCE_DRIFT_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnabledControlFilter, T> g) {
        return obj -> g.apply((EnabledControlFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> controlIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();
        private List<String> driftStatuses = DefaultSdkAutoConstructList.getInstance();
        private List<String> parentIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> inheritanceDriftStatuses = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceDriftStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledControlFilter model) {
            this.controlIdentifiers(model.controlIdentifiers);
            this.statusesWithStrings(model.statuses);
            this.driftStatusesWithStrings(model.driftStatuses);
            this.parentIdentifiers(model.parentIdentifiers);
            this.inheritanceDriftStatusesWithStrings(model.inheritanceDriftStatuses);
            this.resourceDriftStatusesWithStrings(model.resourceDriftStatuses);
        }

        public final Collection<String> getControlIdentifiers() {
            if (this.controlIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.controlIdentifiers;
        }

        public final void setControlIdentifiers(Collection<String> controlIdentifiers) {
            this.controlIdentifiers = ControlIdentifiersCopier.copy(controlIdentifiers);
        }

        @Override
        public final Builder controlIdentifiers(Collection<String> controlIdentifiers) {
            this.controlIdentifiers = ControlIdentifiersCopier.copy(controlIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlIdentifiers(String ... controlIdentifiers) {
            this.controlIdentifiers(Arrays.asList(controlIdentifiers));
            return this;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = EnablementStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = EnablementStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<EnablementStatus> statuses) {
            this.statuses = EnablementStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(EnablementStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final Collection<String> getDriftStatuses() {
            if (this.driftStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.driftStatuses;
        }

        public final void setDriftStatuses(Collection<String> driftStatuses) {
            this.driftStatuses = DriftStatusesCopier.copy(driftStatuses);
        }

        @Override
        public final Builder driftStatusesWithStrings(Collection<String> driftStatuses) {
            this.driftStatuses = DriftStatusesCopier.copy(driftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder driftStatusesWithStrings(String ... driftStatuses) {
            this.driftStatusesWithStrings(Arrays.asList(driftStatuses));
            return this;
        }

        @Override
        public final Builder driftStatuses(Collection<DriftStatus> driftStatuses) {
            this.driftStatuses = DriftStatusesCopier.copyEnumToString(driftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder driftStatuses(DriftStatus ... driftStatuses) {
            this.driftStatuses(Arrays.asList(driftStatuses));
            return this;
        }

        public final Collection<String> getParentIdentifiers() {
            if (this.parentIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parentIdentifiers;
        }

        public final void setParentIdentifiers(Collection<String> parentIdentifiers) {
            this.parentIdentifiers = ParentIdentifiersCopier.copy(parentIdentifiers);
        }

        @Override
        public final Builder parentIdentifiers(Collection<String> parentIdentifiers) {
            this.parentIdentifiers = ParentIdentifiersCopier.copy(parentIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentIdentifiers(String ... parentIdentifiers) {
            this.parentIdentifiers(Arrays.asList(parentIdentifiers));
            return this;
        }

        public final Collection<String> getInheritanceDriftStatuses() {
            if (this.inheritanceDriftStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inheritanceDriftStatuses;
        }

        public final void setInheritanceDriftStatuses(Collection<String> inheritanceDriftStatuses) {
            this.inheritanceDriftStatuses = DriftStatusesCopier.copy(inheritanceDriftStatuses);
        }

        @Override
        public final Builder inheritanceDriftStatusesWithStrings(Collection<String> inheritanceDriftStatuses) {
            this.inheritanceDriftStatuses = DriftStatusesCopier.copy(inheritanceDriftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inheritanceDriftStatusesWithStrings(String ... inheritanceDriftStatuses) {
            this.inheritanceDriftStatusesWithStrings(Arrays.asList(inheritanceDriftStatuses));
            return this;
        }

        @Override
        public final Builder inheritanceDriftStatuses(Collection<DriftStatus> inheritanceDriftStatuses) {
            this.inheritanceDriftStatuses = DriftStatusesCopier.copyEnumToString(inheritanceDriftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inheritanceDriftStatuses(DriftStatus ... inheritanceDriftStatuses) {
            this.inheritanceDriftStatuses(Arrays.asList(inheritanceDriftStatuses));
            return this;
        }

        public final Collection<String> getResourceDriftStatuses() {
            if (this.resourceDriftStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceDriftStatuses;
        }

        public final void setResourceDriftStatuses(Collection<String> resourceDriftStatuses) {
            this.resourceDriftStatuses = DriftStatusesCopier.copy(resourceDriftStatuses);
        }

        @Override
        public final Builder resourceDriftStatusesWithStrings(Collection<String> resourceDriftStatuses) {
            this.resourceDriftStatuses = DriftStatusesCopier.copy(resourceDriftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDriftStatusesWithStrings(String ... resourceDriftStatuses) {
            this.resourceDriftStatusesWithStrings(Arrays.asList(resourceDriftStatuses));
            return this;
        }

        @Override
        public final Builder resourceDriftStatuses(Collection<DriftStatus> resourceDriftStatuses) {
            this.resourceDriftStatuses = DriftStatusesCopier.copyEnumToString(resourceDriftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDriftStatuses(DriftStatus ... resourceDriftStatuses) {
            this.resourceDriftStatuses(Arrays.asList(resourceDriftStatuses));
            return this;
        }

        public EnabledControlFilter build() {
            return new EnabledControlFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnabledControlFilter> {
        public Builder controlIdentifiers(Collection<String> var1);

        public Builder controlIdentifiers(String ... var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<EnablementStatus> var1);

        public Builder statuses(EnablementStatus ... var1);

        public Builder driftStatusesWithStrings(Collection<String> var1);

        public Builder driftStatusesWithStrings(String ... var1);

        public Builder driftStatuses(Collection<DriftStatus> var1);

        public Builder driftStatuses(DriftStatus ... var1);

        public Builder parentIdentifiers(Collection<String> var1);

        public Builder parentIdentifiers(String ... var1);

        public Builder inheritanceDriftStatusesWithStrings(Collection<String> var1);

        public Builder inheritanceDriftStatusesWithStrings(String ... var1);

        public Builder inheritanceDriftStatuses(Collection<DriftStatus> var1);

        public Builder inheritanceDriftStatuses(DriftStatus ... var1);

        public Builder resourceDriftStatusesWithStrings(Collection<String> var1);

        public Builder resourceDriftStatusesWithStrings(String ... var1);

        public Builder resourceDriftStatuses(Collection<DriftStatus> var1);

        public Builder resourceDriftStatuses(DriftStatus ... var1);
    }
}

