/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.LandingZoneDriftStatusSummary;
import software.amazon.awssdk.services.controltower.model.LandingZoneStatus;
import software.amazon.awssdk.services.controltower.model.RemediationType;
import software.amazon.awssdk.services.controltower.model.RemediationTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LandingZoneDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LandingZoneDetail> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(LandingZoneDetail.getter(LandingZoneDetail::version)).setter(LandingZoneDetail.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<List<String>> REMEDIATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("remediationTypes").getter(LandingZoneDetail.getter(LandingZoneDetail::remediationTypesAsStrings)).setter(LandingZoneDetail.setter(Builder::remediationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LandingZoneDetail.getter(LandingZoneDetail::arn)).setter(LandingZoneDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LandingZoneDetail.getter(LandingZoneDetail::statusAsString)).setter(LandingZoneDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> LATEST_AVAILABLE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestAvailableVersion").getter(LandingZoneDetail.getter(LandingZoneDetail::latestAvailableVersion)).setter(LandingZoneDetail.setter(Builder::latestAvailableVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAvailableVersion").build()}).build();
    private static final SdkField<LandingZoneDriftStatusSummary> DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("driftStatus").getter(LandingZoneDetail.getter(LandingZoneDetail::driftStatus)).setter(LandingZoneDetail.setter(Builder::driftStatus)).constructor(LandingZoneDriftStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatus").build()}).build();
    private static final SdkField<Document> MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("manifest").getter(LandingZoneDetail.getter(LandingZoneDetail::manifest)).setter(LandingZoneDetail.setter(Builder::manifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, REMEDIATION_TYPES_FIELD, ARN_FIELD, STATUS_FIELD, LATEST_AVAILABLE_VERSION_FIELD, DRIFT_STATUS_FIELD, MANIFEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LandingZoneDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String version;
    private final List<String> remediationTypes;
    private final String arn;
    private final String status;
    private final String latestAvailableVersion;
    private final LandingZoneDriftStatusSummary driftStatus;
    private final Document manifest;

    private LandingZoneDetail(BuilderImpl builder) {
        this.version = builder.version;
        this.remediationTypes = builder.remediationTypes;
        this.arn = builder.arn;
        this.status = builder.status;
        this.latestAvailableVersion = builder.latestAvailableVersion;
        this.driftStatus = builder.driftStatus;
        this.manifest = builder.manifest;
    }

    public final String version() {
        return this.version;
    }

    public final List<RemediationType> remediationTypes() {
        return RemediationTypesCopier.copyStringToEnum(this.remediationTypes);
    }

    public final boolean hasRemediationTypes() {
        return this.remediationTypes != null && !(this.remediationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> remediationTypesAsStrings() {
        return this.remediationTypes;
    }

    public final String arn() {
        return this.arn;
    }

    public final LandingZoneStatus status() {
        return LandingZoneStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String latestAvailableVersion() {
        return this.latestAvailableVersion;
    }

    public final LandingZoneDriftStatusSummary driftStatus() {
        return this.driftStatus;
    }

    public final Document manifest() {
        return this.manifest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemediationTypes() ? this.remediationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAvailableVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LandingZoneDetail)) {
            return false;
        }
        LandingZoneDetail other = (LandingZoneDetail)obj;
        return Objects.equals(this.version(), other.version()) && this.hasRemediationTypes() == other.hasRemediationTypes() && Objects.equals(this.remediationTypesAsStrings(), other.remediationTypesAsStrings()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.latestAvailableVersion(), other.latestAvailableVersion()) && Objects.equals(this.driftStatus(), other.driftStatus()) && Objects.equals(this.manifest(), other.manifest());
    }

    public final String toString() {
        return ToString.builder((String)"LandingZoneDetail").add("Version", (Object)this.version()).add("RemediationTypes", this.hasRemediationTypes() ? this.remediationTypesAsStrings() : null).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("LatestAvailableVersion", (Object)this.latestAvailableVersion()).add("DriftStatus", (Object)this.driftStatus()).add("Manifest", (Object)this.manifest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "remediationTypes": {
                return Optional.ofNullable(clazz.cast(this.remediationTypesAsStrings()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "latestAvailableVersion": {
                return Optional.ofNullable(clazz.cast(this.latestAvailableVersion()));
            }
            case "driftStatus": {
                return Optional.ofNullable(clazz.cast(this.driftStatus()));
            }
            case "manifest": {
                return Optional.ofNullable(clazz.cast(this.manifest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", VERSION_FIELD);
        map.put("remediationTypes", REMEDIATION_TYPES_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("latestAvailableVersion", LATEST_AVAILABLE_VERSION_FIELD);
        map.put("driftStatus", DRIFT_STATUS_FIELD);
        map.put("manifest", MANIFEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LandingZoneDetail, T> g) {
        return obj -> g.apply((LandingZoneDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private List<String> remediationTypes = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private String status;
        private String latestAvailableVersion;
        private LandingZoneDriftStatusSummary driftStatus;
        private Document manifest;

        private BuilderImpl() {
        }

        private BuilderImpl(LandingZoneDetail model) {
            this.version(model.version);
            this.remediationTypesWithStrings(model.remediationTypes);
            this.arn(model.arn);
            this.status(model.status);
            this.latestAvailableVersion(model.latestAvailableVersion);
            this.driftStatus(model.driftStatus);
            this.manifest(model.manifest);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getRemediationTypes() {
            if (this.remediationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.remediationTypes;
        }

        public final void setRemediationTypes(Collection<String> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copy(remediationTypes);
        }

        @Override
        public final Builder remediationTypesWithStrings(Collection<String> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copy(remediationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationTypesWithStrings(String ... remediationTypes) {
            this.remediationTypesWithStrings(Arrays.asList(remediationTypes));
            return this;
        }

        @Override
        public final Builder remediationTypes(Collection<RemediationType> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copyEnumToString(remediationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationTypes(RemediationType ... remediationTypes) {
            this.remediationTypes(Arrays.asList(remediationTypes));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LandingZoneStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLatestAvailableVersion() {
            return this.latestAvailableVersion;
        }

        public final void setLatestAvailableVersion(String latestAvailableVersion) {
            this.latestAvailableVersion = latestAvailableVersion;
        }

        @Override
        public final Builder latestAvailableVersion(String latestAvailableVersion) {
            this.latestAvailableVersion = latestAvailableVersion;
            return this;
        }

        public final LandingZoneDriftStatusSummary.Builder getDriftStatus() {
            return this.driftStatus != null ? this.driftStatus.toBuilder() : null;
        }

        public final void setDriftStatus(LandingZoneDriftStatusSummary.BuilderImpl driftStatus) {
            this.driftStatus = driftStatus != null ? driftStatus.build() : null;
        }

        @Override
        public final Builder driftStatus(LandingZoneDriftStatusSummary driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        public final Document getManifest() {
            return this.manifest;
        }

        public final void setManifest(Document manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(Document manifest) {
            this.manifest = manifest;
            return this;
        }

        public LandingZoneDetail build() {
            return new LandingZoneDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LandingZoneDetail> {
        public Builder version(String var1);

        public Builder remediationTypesWithStrings(Collection<String> var1);

        public Builder remediationTypesWithStrings(String ... var1);

        public Builder remediationTypes(Collection<RemediationType> var1);

        public Builder remediationTypes(RemediationType ... var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(LandingZoneStatus var1);

        public Builder latestAvailableVersion(String var1);

        public Builder driftStatus(LandingZoneDriftStatusSummary var1);

        default public Builder driftStatus(Consumer<LandingZoneDriftStatusSummary.Builder> driftStatus) {
            return this.driftStatus((LandingZoneDriftStatusSummary)((LandingZoneDriftStatusSummary.Builder)LandingZoneDriftStatusSummary.builder().applyMutation(driftStatus)).build());
        }

        public Builder manifest(Document var1);
    }
}

