/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.controltower.model.ControlTowerRequest;
import software.amazon.awssdk.services.controltower.model.RemediationType;
import software.amazon.awssdk.services.controltower.model.RemediationTypesCopier;
import software.amazon.awssdk.services.controltower.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLandingZoneRequest
extends ControlTowerRequest
implements ToCopyableBuilder<Builder, CreateLandingZoneRequest> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(CreateLandingZoneRequest.getter(CreateLandingZoneRequest::version)).setter(CreateLandingZoneRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<List<String>> REMEDIATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("remediationTypes").getter(CreateLandingZoneRequest.getter(CreateLandingZoneRequest::remediationTypesAsStrings)).setter(CreateLandingZoneRequest.setter(Builder::remediationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateLandingZoneRequest.getter(CreateLandingZoneRequest::tags)).setter(CreateLandingZoneRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Document> MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("manifest").getter(CreateLandingZoneRequest.getter(CreateLandingZoneRequest::manifest)).setter(CreateLandingZoneRequest.setter(Builder::manifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, REMEDIATION_TYPES_FIELD, TAGS_FIELD, MANIFEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLandingZoneRequest.memberNameToFieldInitializer();
    private final String version;
    private final List<String> remediationTypes;
    private final Map<String, String> tags;
    private final Document manifest;

    private CreateLandingZoneRequest(BuilderImpl builder) {
        super(builder);
        this.version = builder.version;
        this.remediationTypes = builder.remediationTypes;
        this.tags = builder.tags;
        this.manifest = builder.manifest;
    }

    public final String version() {
        return this.version;
    }

    public final List<RemediationType> remediationTypes() {
        return RemediationTypesCopier.copyStringToEnum(this.remediationTypes);
    }

    public final boolean hasRemediationTypes() {
        return this.remediationTypes != null && !(this.remediationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> remediationTypesAsStrings() {
        return this.remediationTypes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Document manifest() {
        return this.manifest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemediationTypes() ? this.remediationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.manifest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLandingZoneRequest)) {
            return false;
        }
        CreateLandingZoneRequest other = (CreateLandingZoneRequest)((Object)obj);
        return Objects.equals(this.version(), other.version()) && this.hasRemediationTypes() == other.hasRemediationTypes() && Objects.equals(this.remediationTypesAsStrings(), other.remediationTypesAsStrings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.manifest(), other.manifest());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLandingZoneRequest").add("Version", (Object)this.version()).add("RemediationTypes", this.hasRemediationTypes() ? this.remediationTypesAsStrings() : null).add("Tags", this.hasTags() ? this.tags() : null).add("Manifest", (Object)this.manifest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "remediationTypes": {
                return Optional.ofNullable(clazz.cast(this.remediationTypesAsStrings()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "manifest": {
                return Optional.ofNullable(clazz.cast(this.manifest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", VERSION_FIELD);
        map.put("remediationTypes", REMEDIATION_TYPES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("manifest", MANIFEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLandingZoneRequest, T> g) {
        return obj -> g.apply((CreateLandingZoneRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerRequest.BuilderImpl
    implements Builder {
        private String version;
        private List<String> remediationTypes = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Document manifest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLandingZoneRequest model) {
            super(model);
            this.version(model.version);
            this.remediationTypesWithStrings(model.remediationTypes);
            this.tags(model.tags);
            this.manifest(model.manifest);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getRemediationTypes() {
            if (this.remediationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.remediationTypes;
        }

        public final void setRemediationTypes(Collection<String> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copy(remediationTypes);
        }

        @Override
        public final Builder remediationTypesWithStrings(Collection<String> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copy(remediationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationTypesWithStrings(String ... remediationTypes) {
            this.remediationTypesWithStrings(Arrays.asList(remediationTypes));
            return this;
        }

        @Override
        public final Builder remediationTypes(Collection<RemediationType> remediationTypes) {
            this.remediationTypes = RemediationTypesCopier.copyEnumToString(remediationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationTypes(RemediationType ... remediationTypes) {
            this.remediationTypes(Arrays.asList(remediationTypes));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Document getManifest() {
            return this.manifest;
        }

        public final void setManifest(Document manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(Document manifest) {
            this.manifest = manifest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLandingZoneRequest build() {
            return new CreateLandingZoneRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ControlTowerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLandingZoneRequest> {
        public Builder version(String var1);

        public Builder remediationTypesWithStrings(Collection<String> var1);

        public Builder remediationTypesWithStrings(String ... var1);

        public Builder remediationTypes(Collection<RemediationType> var1);

        public Builder remediationTypes(RemediationType ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder manifest(Document var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

