/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineDriftStatusSummary;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineParameterSummariesCopier;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineParameterSummary;
import software.amazon.awssdk.services.controltower.model.EnablementStatusSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnabledBaselineDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnabledBaselineDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EnabledBaselineDetails.getter(EnabledBaselineDetails::arn)).setter(EnabledBaselineDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> BASELINE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baselineIdentifier").getter(EnabledBaselineDetails.getter(EnabledBaselineDetails::baselineIdentifier)).setter(EnabledBaselineDetails.setter(Builder::baselineIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineIdentifier").build()}).build();
    private static final SdkField<String> BASELINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baselineVersion").getter(EnabledBaselineDetails.getter(EnabledBaselineDetails::baselineVersion)).setter(EnabledBaselineDetails.setter(Builder::baselineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineVersion").build()}).build();
    private static final SdkField<EnabledBaselineDriftStatusSummary> DRIFT_STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("driftStatusSummary").getter(EnabledBaselineDetails.getter(EnabledBaselineDetails::driftStatusSummary)).setter(EnabledBaselineDetails.setter(Builder::driftStatusSummary)).constructor(EnabledBaselineDriftStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatusSummary").build()}).build();
    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetIdentifier").getter(EnabledBaselineDetails.getter(EnabledBaselineDetails::targetIdentifier)).setter(EnabledBaselineDetails.setter(Builder::targetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()}).build();
    private static final SdkField<String> PARENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentIdentifier").getter(EnabledBaselineDetails.getter(EnabledBaselineDetails::parentIdentifier)).setter(EnabledBaselineDetails.setter(Builder::parentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIdentifier").build()}).build();
    private static final SdkField<EnablementStatusSummary> STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusSummary").getter(EnabledBaselineDetails.getter(EnabledBaselineDetails::statusSummary)).setter(EnabledBaselineDetails.setter(Builder::statusSummary)).constructor(EnablementStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()}).build();
    private static final SdkField<List<EnabledBaselineParameterSummary>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(EnabledBaselineDetails.getter(EnabledBaselineDetails::parameters)).setter(EnabledBaselineDetails.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnabledBaselineParameterSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BASELINE_IDENTIFIER_FIELD, BASELINE_VERSION_FIELD, DRIFT_STATUS_SUMMARY_FIELD, TARGET_IDENTIFIER_FIELD, PARENT_IDENTIFIER_FIELD, STATUS_SUMMARY_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnabledBaselineDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String baselineIdentifier;
    private final String baselineVersion;
    private final EnabledBaselineDriftStatusSummary driftStatusSummary;
    private final String targetIdentifier;
    private final String parentIdentifier;
    private final EnablementStatusSummary statusSummary;
    private final List<EnabledBaselineParameterSummary> parameters;

    private EnabledBaselineDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.baselineIdentifier = builder.baselineIdentifier;
        this.baselineVersion = builder.baselineVersion;
        this.driftStatusSummary = builder.driftStatusSummary;
        this.targetIdentifier = builder.targetIdentifier;
        this.parentIdentifier = builder.parentIdentifier;
        this.statusSummary = builder.statusSummary;
        this.parameters = builder.parameters;
    }

    public final String arn() {
        return this.arn;
    }

    public final String baselineIdentifier() {
        return this.baselineIdentifier;
    }

    public final String baselineVersion() {
        return this.baselineVersion;
    }

    public final EnabledBaselineDriftStatusSummary driftStatusSummary() {
        return this.driftStatusSummary;
    }

    public final String targetIdentifier() {
        return this.targetIdentifier;
    }

    public final String parentIdentifier() {
        return this.parentIdentifier;
    }

    public final EnablementStatusSummary statusSummary() {
        return this.statusSummary;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<EnabledBaselineParameterSummary> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftStatusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledBaselineDetails)) {
            return false;
        }
        EnabledBaselineDetails other = (EnabledBaselineDetails)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.baselineIdentifier(), other.baselineIdentifier()) && Objects.equals(this.baselineVersion(), other.baselineVersion()) && Objects.equals(this.driftStatusSummary(), other.driftStatusSummary()) && Objects.equals(this.targetIdentifier(), other.targetIdentifier()) && Objects.equals(this.parentIdentifier(), other.parentIdentifier()) && Objects.equals(this.statusSummary(), other.statusSummary()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"EnabledBaselineDetails").add("Arn", (Object)this.arn()).add("BaselineIdentifier", (Object)this.baselineIdentifier()).add("BaselineVersion", (Object)this.baselineVersion()).add("DriftStatusSummary", (Object)this.driftStatusSummary()).add("TargetIdentifier", (Object)this.targetIdentifier()).add("ParentIdentifier", (Object)this.parentIdentifier()).add("StatusSummary", (Object)this.statusSummary()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "baselineIdentifier": {
                return Optional.ofNullable(clazz.cast(this.baselineIdentifier()));
            }
            case "baselineVersion": {
                return Optional.ofNullable(clazz.cast(this.baselineVersion()));
            }
            case "driftStatusSummary": {
                return Optional.ofNullable(clazz.cast(this.driftStatusSummary()));
            }
            case "targetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetIdentifier()));
            }
            case "parentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.parentIdentifier()));
            }
            case "statusSummary": {
                return Optional.ofNullable(clazz.cast(this.statusSummary()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("baselineIdentifier", BASELINE_IDENTIFIER_FIELD);
        map.put("baselineVersion", BASELINE_VERSION_FIELD);
        map.put("driftStatusSummary", DRIFT_STATUS_SUMMARY_FIELD);
        map.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        map.put("parentIdentifier", PARENT_IDENTIFIER_FIELD);
        map.put("statusSummary", STATUS_SUMMARY_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnabledBaselineDetails, T> g) {
        return obj -> g.apply((EnabledBaselineDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String baselineIdentifier;
        private String baselineVersion;
        private EnabledBaselineDriftStatusSummary driftStatusSummary;
        private String targetIdentifier;
        private String parentIdentifier;
        private EnablementStatusSummary statusSummary;
        private List<EnabledBaselineParameterSummary> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledBaselineDetails model) {
            this.arn(model.arn);
            this.baselineIdentifier(model.baselineIdentifier);
            this.baselineVersion(model.baselineVersion);
            this.driftStatusSummary(model.driftStatusSummary);
            this.targetIdentifier(model.targetIdentifier);
            this.parentIdentifier(model.parentIdentifier);
            this.statusSummary(model.statusSummary);
            this.parameters(model.parameters);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBaselineIdentifier() {
            return this.baselineIdentifier;
        }

        public final void setBaselineIdentifier(String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
        }

        @Override
        public final Builder baselineIdentifier(String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
            return this;
        }

        public final String getBaselineVersion() {
            return this.baselineVersion;
        }

        public final void setBaselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
        }

        @Override
        public final Builder baselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
            return this;
        }

        public final EnabledBaselineDriftStatusSummary.Builder getDriftStatusSummary() {
            return this.driftStatusSummary != null ? this.driftStatusSummary.toBuilder() : null;
        }

        public final void setDriftStatusSummary(EnabledBaselineDriftStatusSummary.BuilderImpl driftStatusSummary) {
            this.driftStatusSummary = driftStatusSummary != null ? driftStatusSummary.build() : null;
        }

        @Override
        public final Builder driftStatusSummary(EnabledBaselineDriftStatusSummary driftStatusSummary) {
            this.driftStatusSummary = driftStatusSummary;
            return this;
        }

        public final String getTargetIdentifier() {
            return this.targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public final String getParentIdentifier() {
            return this.parentIdentifier;
        }

        public final void setParentIdentifier(String parentIdentifier) {
            this.parentIdentifier = parentIdentifier;
        }

        @Override
        public final Builder parentIdentifier(String parentIdentifier) {
            this.parentIdentifier = parentIdentifier;
            return this;
        }

        public final EnablementStatusSummary.Builder getStatusSummary() {
            return this.statusSummary != null ? this.statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(EnablementStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(EnablementStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final List<EnabledBaselineParameterSummary.Builder> getParameters() {
            List<EnabledBaselineParameterSummary.Builder> result = EnabledBaselineParameterSummariesCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<EnabledBaselineParameterSummary.BuilderImpl> parameters) {
            this.parameters = EnabledBaselineParameterSummariesCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<EnabledBaselineParameterSummary> parameters) {
            this.parameters = EnabledBaselineParameterSummariesCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(EnabledBaselineParameterSummary ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<EnabledBaselineParameterSummary.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (EnabledBaselineParameterSummary)((EnabledBaselineParameterSummary.Builder)EnabledBaselineParameterSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EnabledBaselineDetails build() {
            return new EnabledBaselineDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnabledBaselineDetails> {
        public Builder arn(String var1);

        public Builder baselineIdentifier(String var1);

        public Builder baselineVersion(String var1);

        public Builder driftStatusSummary(EnabledBaselineDriftStatusSummary var1);

        default public Builder driftStatusSummary(Consumer<EnabledBaselineDriftStatusSummary.Builder> driftStatusSummary) {
            return this.driftStatusSummary((EnabledBaselineDriftStatusSummary)((EnabledBaselineDriftStatusSummary.Builder)EnabledBaselineDriftStatusSummary.builder().applyMutation(driftStatusSummary)).build());
        }

        public Builder targetIdentifier(String var1);

        public Builder parentIdentifier(String var1);

        public Builder statusSummary(EnablementStatusSummary var1);

        default public Builder statusSummary(Consumer<EnablementStatusSummary.Builder> statusSummary) {
            return this.statusSummary((EnablementStatusSummary)((EnablementStatusSummary.Builder)EnablementStatusSummary.builder().applyMutation(statusSummary)).build());
        }

        public Builder parameters(Collection<EnabledBaselineParameterSummary> var1);

        public Builder parameters(EnabledBaselineParameterSummary ... var1);

        public Builder parameters(Consumer<EnabledBaselineParameterSummary.Builder> ... var1);
    }
}

