/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.EnablementStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnablementStatusSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnablementStatusSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(EnablementStatusSummary.getter(EnablementStatusSummary::statusAsString)).setter(EnablementStatusSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> LAST_OPERATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastOperationIdentifier").getter(EnablementStatusSummary.getter(EnablementStatusSummary::lastOperationIdentifier)).setter(EnablementStatusSummary.setter(Builder::lastOperationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastOperationIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, LAST_OPERATION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnablementStatusSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String lastOperationIdentifier;

    private EnablementStatusSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.lastOperationIdentifier = builder.lastOperationIdentifier;
    }

    public final EnablementStatus status() {
        return EnablementStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String lastOperationIdentifier() {
        return this.lastOperationIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastOperationIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnablementStatusSummary)) {
            return false;
        }
        EnablementStatusSummary other = (EnablementStatusSummary)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastOperationIdentifier(), other.lastOperationIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"EnablementStatusSummary").add("Status", (Object)this.statusAsString()).add("LastOperationIdentifier", (Object)this.lastOperationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastOperationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.lastOperationIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("status", STATUS_FIELD);
        map.put("lastOperationIdentifier", LAST_OPERATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnablementStatusSummary, T> g) {
        return obj -> g.apply((EnablementStatusSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String lastOperationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EnablementStatusSummary model) {
            this.status(model.status);
            this.lastOperationIdentifier(model.lastOperationIdentifier);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnablementStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLastOperationIdentifier() {
            return this.lastOperationIdentifier;
        }

        public final void setLastOperationIdentifier(String lastOperationIdentifier) {
            this.lastOperationIdentifier = lastOperationIdentifier;
        }

        @Override
        public final Builder lastOperationIdentifier(String lastOperationIdentifier) {
            this.lastOperationIdentifier = lastOperationIdentifier;
            return this;
        }

        public EnablementStatusSummary build() {
            return new EnablementStatusSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnablementStatusSummary> {
        public Builder status(String var1);

        public Builder status(EnablementStatus var1);

        public Builder lastOperationIdentifier(String var1);
    }
}

