/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerAsyncClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.BaselineSummary;
import software.amazon.awssdk.services.controltower.model.ListBaselinesRequest;
import software.amazon.awssdk.services.controltower.model.ListBaselinesResponse;

public class ListBaselinesPublisher
implements SdkPublisher<ListBaselinesResponse> {
    private final ControlTowerAsyncClient client;
    private final ListBaselinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBaselinesPublisher(ControlTowerAsyncClient client, ListBaselinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBaselinesPublisher(ControlTowerAsyncClient client, ListBaselinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBaselinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBaselinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BaselineSummary> baselines() {
        Function<ListBaselinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.baselines() != null) {
                return response.baselines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBaselinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBaselinesResponseFetcher
    implements AsyncPageFetcher<ListBaselinesResponse> {
        private ListBaselinesResponseFetcher() {
        }

        public boolean hasNextPage(ListBaselinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBaselinesResponse> nextPage(ListBaselinesResponse previousPage) {
            if (previousPage == null) {
                return ListBaselinesPublisher.this.client.listBaselines(ListBaselinesPublisher.this.firstRequest);
            }
            return ListBaselinesPublisher.this.client.listBaselines((ListBaselinesRequest)((Object)ListBaselinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

