/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkResourceUtilization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkResourceUtilization> {
    private static final SdkField<String> NETWORK_IN_BYTES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInBytesPerSecond").getter(NetworkResourceUtilization.getter(NetworkResourceUtilization::networkInBytesPerSecond)).setter(NetworkResourceUtilization.setter(Builder::networkInBytesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInBytesPerSecond").build()}).build();
    private static final SdkField<String> NETWORK_OUT_BYTES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkOutBytesPerSecond").getter(NetworkResourceUtilization.getter(NetworkResourceUtilization::networkOutBytesPerSecond)).setter(NetworkResourceUtilization.setter(Builder::networkOutBytesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkOutBytesPerSecond").build()}).build();
    private static final SdkField<String> NETWORK_PACKETS_IN_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkPacketsInPerSecond").getter(NetworkResourceUtilization.getter(NetworkResourceUtilization::networkPacketsInPerSecond)).setter(NetworkResourceUtilization.setter(Builder::networkPacketsInPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPacketsInPerSecond").build()}).build();
    private static final SdkField<String> NETWORK_PACKETS_OUT_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkPacketsOutPerSecond").getter(NetworkResourceUtilization.getter(NetworkResourceUtilization::networkPacketsOutPerSecond)).setter(NetworkResourceUtilization.setter(Builder::networkPacketsOutPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPacketsOutPerSecond").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_IN_BYTES_PER_SECOND_FIELD, NETWORK_OUT_BYTES_PER_SECOND_FIELD, NETWORK_PACKETS_IN_PER_SECOND_FIELD, NETWORK_PACKETS_OUT_PER_SECOND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkResourceUtilization.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String networkInBytesPerSecond;
    private final String networkOutBytesPerSecond;
    private final String networkPacketsInPerSecond;
    private final String networkPacketsOutPerSecond;

    private NetworkResourceUtilization(BuilderImpl builder) {
        this.networkInBytesPerSecond = builder.networkInBytesPerSecond;
        this.networkOutBytesPerSecond = builder.networkOutBytesPerSecond;
        this.networkPacketsInPerSecond = builder.networkPacketsInPerSecond;
        this.networkPacketsOutPerSecond = builder.networkPacketsOutPerSecond;
    }

    public final String networkInBytesPerSecond() {
        return this.networkInBytesPerSecond;
    }

    public final String networkOutBytesPerSecond() {
        return this.networkOutBytesPerSecond;
    }

    public final String networkPacketsInPerSecond() {
        return this.networkPacketsInPerSecond;
    }

    public final String networkPacketsOutPerSecond() {
        return this.networkPacketsOutPerSecond;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkOutBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPacketsInPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPacketsOutPerSecond());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkResourceUtilization)) {
            return false;
        }
        NetworkResourceUtilization other = (NetworkResourceUtilization)obj;
        return Objects.equals(this.networkInBytesPerSecond(), other.networkInBytesPerSecond()) && Objects.equals(this.networkOutBytesPerSecond(), other.networkOutBytesPerSecond()) && Objects.equals(this.networkPacketsInPerSecond(), other.networkPacketsInPerSecond()) && Objects.equals(this.networkPacketsOutPerSecond(), other.networkPacketsOutPerSecond());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkResourceUtilization").add("NetworkInBytesPerSecond", (Object)this.networkInBytesPerSecond()).add("NetworkOutBytesPerSecond", (Object)this.networkOutBytesPerSecond()).add("NetworkPacketsInPerSecond", (Object)this.networkPacketsInPerSecond()).add("NetworkPacketsOutPerSecond", (Object)this.networkPacketsOutPerSecond()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInBytesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.networkInBytesPerSecond()));
            }
            case "NetworkOutBytesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.networkOutBytesPerSecond()));
            }
            case "NetworkPacketsInPerSecond": {
                return Optional.ofNullable(clazz.cast(this.networkPacketsInPerSecond()));
            }
            case "NetworkPacketsOutPerSecond": {
                return Optional.ofNullable(clazz.cast(this.networkPacketsOutPerSecond()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("NetworkInBytesPerSecond", NETWORK_IN_BYTES_PER_SECOND_FIELD);
        map.put("NetworkOutBytesPerSecond", NETWORK_OUT_BYTES_PER_SECOND_FIELD);
        map.put("NetworkPacketsInPerSecond", NETWORK_PACKETS_IN_PER_SECOND_FIELD);
        map.put("NetworkPacketsOutPerSecond", NETWORK_PACKETS_OUT_PER_SECOND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkResourceUtilization, T> g) {
        return obj -> g.apply((NetworkResourceUtilization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInBytesPerSecond;
        private String networkOutBytesPerSecond;
        private String networkPacketsInPerSecond;
        private String networkPacketsOutPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkResourceUtilization model) {
            this.networkInBytesPerSecond(model.networkInBytesPerSecond);
            this.networkOutBytesPerSecond(model.networkOutBytesPerSecond);
            this.networkPacketsInPerSecond(model.networkPacketsInPerSecond);
            this.networkPacketsOutPerSecond(model.networkPacketsOutPerSecond);
        }

        public final String getNetworkInBytesPerSecond() {
            return this.networkInBytesPerSecond;
        }

        public final void setNetworkInBytesPerSecond(String networkInBytesPerSecond) {
            this.networkInBytesPerSecond = networkInBytesPerSecond;
        }

        @Override
        public final Builder networkInBytesPerSecond(String networkInBytesPerSecond) {
            this.networkInBytesPerSecond = networkInBytesPerSecond;
            return this;
        }

        public final String getNetworkOutBytesPerSecond() {
            return this.networkOutBytesPerSecond;
        }

        public final void setNetworkOutBytesPerSecond(String networkOutBytesPerSecond) {
            this.networkOutBytesPerSecond = networkOutBytesPerSecond;
        }

        @Override
        public final Builder networkOutBytesPerSecond(String networkOutBytesPerSecond) {
            this.networkOutBytesPerSecond = networkOutBytesPerSecond;
            return this;
        }

        public final String getNetworkPacketsInPerSecond() {
            return this.networkPacketsInPerSecond;
        }

        public final void setNetworkPacketsInPerSecond(String networkPacketsInPerSecond) {
            this.networkPacketsInPerSecond = networkPacketsInPerSecond;
        }

        @Override
        public final Builder networkPacketsInPerSecond(String networkPacketsInPerSecond) {
            this.networkPacketsInPerSecond = networkPacketsInPerSecond;
            return this;
        }

        public final String getNetworkPacketsOutPerSecond() {
            return this.networkPacketsOutPerSecond;
        }

        public final void setNetworkPacketsOutPerSecond(String networkPacketsOutPerSecond) {
            this.networkPacketsOutPerSecond = networkPacketsOutPerSecond;
        }

        @Override
        public final Builder networkPacketsOutPerSecond(String networkPacketsOutPerSecond) {
            this.networkPacketsOutPerSecond = networkPacketsOutPerSecond;
            return this;
        }

        public NetworkResourceUtilization build() {
            return new NetworkResourceUtilization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkResourceUtilization> {
        public Builder networkInBytesPerSecond(String var1);

        public Builder networkOutBytesPerSecond(String var1);

        public Builder networkPacketsInPerSecond(String var1);

        public Builder networkPacketsOutPerSecond(String var1);
    }
}

