/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.Anomaly;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse;

public class GetAnomaliesPublisher
implements SdkPublisher<GetAnomaliesResponse> {
    private final CostExplorerAsyncClient client;
    private final GetAnomaliesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAnomaliesPublisher(CostExplorerAsyncClient client, GetAnomaliesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAnomaliesPublisher(CostExplorerAsyncClient client, GetAnomaliesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAnomaliesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAnomaliesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Anomaly> anomalies() {
        Function<GetAnomaliesResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalies() != null) {
                return response.anomalies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAnomaliesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetAnomaliesResponseFetcher
    implements AsyncPageFetcher<GetAnomaliesResponse> {
        private GetAnomaliesResponseFetcher() {
        }

        public boolean hasNextPage(GetAnomaliesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<GetAnomaliesResponse> nextPage(GetAnomaliesResponse previousPage) {
            if (previousPage == null) {
                return GetAnomaliesPublisher.this.client.getAnomalies(GetAnomaliesPublisher.this.firstRequest);
            }
            return GetAnomaliesPublisher.this.client.getAnomalies((GetAnomaliesRequest)((Object)GetAnomaliesPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

